/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.blockchain.ChildChain;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.shuffling.ShufflingHome;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetAssignedShufflings
extends APIServlet.APIRequestHandler {
    static final GetAssignedShufflings instance = new GetAssignedShufflings();

    private GetAssignedShufflings() {
        super(new APITag[]{APITag.SHUFFLING}, "account", "includeHoldingInfo", "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        long l = ParameterParser.getAccountId(httpServletRequest, "account", true);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeHoldingInfo"));
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        jSONObject.put((Object)"shufflings", (Object)jSONArray);
        try (DbIterator<ShufflingHome.Shuffling> dbIterator = childChain.getShufflingHome().getAssignedShufflings(l, n, n2);){
            for (ShufflingHome.Shuffling shuffling : dbIterator) {
                jSONArray.add((Object)JSONData.shuffling(shuffling, bl));
            }
        }
        return jSONObject;
    }
}

