/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Chain;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetBalances
extends APIServlet.APIRequestHandler {
    static final GetBalances instance = new GetBalances();

    private GetBalances() {
        super(new APITag[]{APITag.ACCOUNTS}, "chain", "chain", "account", "height");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getAccountId(httpServletRequest, true);
        int n = ParameterParser.getHeight(httpServletRequest);
        Nxt.getBlockchain().readLock();
        try {
            JSONObject jSONObject;
            if (n < 0) {
                n = Nxt.getBlockchain().getHeight();
            }
            if ((jSONObject = httpServletRequest.getParameterValues("chain")) == null || ((String[])jSONObject).length == 0) {
                JSONStreamAware jSONStreamAware = JSONResponses.MISSING_CHAIN;
                return jSONStreamAware;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (String string : jSONObject) {
                Chain chain = Chain.getChain(string.toUpperCase(Locale.ROOT));
                if (chain == null) {
                    try {
                        chain = Chain.getChain(Integer.parseInt(string));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (chain == null) {
                        JSONStreamAware jSONStreamAware = JSONResponses.UNKNOWN_CHAIN;
                        return jSONStreamAware;
                    }
                }
                jSONObject2.put((Object)chain.getId(), (Object)JSONData.balance(chain, l, n));
            }
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put((Object)"balances", (Object)jSONObject2);
            JSONObject jSONObject4 = jSONObject3;
            return jSONObject4;
        }
        finally {
            Nxt.getBlockchain().readUnlock();
        }
    }
}

