/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.blockchain.Block;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class GetBlock
extends APIServlet.APIRequestHandler {
    static final GetBlock instance = new GetBlock();

    private GetBlock() {
        super(new APITag[]{APITag.BLOCKS}, "block", "height", "timestamp", "includeTransactions", "includeExecutedPhased");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        int n;
        Block block;
        String string = Convert.emptyToNull(httpServletRequest.getParameter("block"));
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter("height"));
        String string3 = Convert.emptyToNull(httpServletRequest.getParameter("timestamp"));
        if (string != null) {
            try {
                block = Nxt.getBlockchain().getBlock(Convert.parseUnsignedLong(string));
            }
            catch (RuntimeException runtimeException) {
                return JSONResponses.INCORRECT_BLOCK;
            }
        } else if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
                if (n < 0 || n > Nxt.getBlockchain().getHeight()) {
                    return JSONResponses.INCORRECT_HEIGHT;
                }
                block = Nxt.getBlockchain().getBlockAtHeight(n);
            }
            catch (RuntimeException runtimeException) {
                return JSONResponses.INCORRECT_HEIGHT;
            }
        } else if (string3 != null) {
            try {
                n = Integer.parseInt(string3);
                if (n < 0) {
                    return JSONResponses.INCORRECT_TIMESTAMP;
                }
                block = Nxt.getBlockchain().getLastBlock(n);
            }
            catch (RuntimeException runtimeException) {
                return JSONResponses.INCORRECT_TIMESTAMP;
            }
        } else {
            block = Nxt.getBlockchain().getLastBlock();
        }
        if (block == null) {
            return JSONResponses.UNKNOWN_BLOCK;
        }
        n = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeTransactions")) ? 1 : 0;
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeExecutedPhased"));
        return JSONData.block(block, n != 0, bl);
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

