/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.account.Account;
import nxt.blockchain.Bundler;
import nxt.blockchain.ChildChain;
import nxt.crypto.Crypto;
import nxt.http.API;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetBundlers
extends APIServlet.APIRequestHandler {
    static final GetBundlers instance = new GetBundlers();

    private GetBundlers() {
        super(new APITag[]{APITag.FORGING}, "account", "secretPhrase", "adminPassword");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        List<Object> list;
        Bundler bundler2;
        String string = ParameterParser.getSecretPhrase(httpServletRequest, false);
        long l = ParameterParser.getAccountId(httpServletRequest, false);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest, false);
        if (string != null) {
            if (l != 0L && Account.getId(Crypto.getPublicKey(string)) != l) {
                return JSONResponses.INCORRECT_ACCOUNT;
            }
            l = Account.getId(Crypto.getPublicKey(string));
            list = childChain == null ? Bundler.getAccountBundlers(l) : ((bundler2 = Bundler.getBundler(childChain, l)) == null ? Collections.emptyList() : Collections.singletonList(bundler2));
        } else {
            API.verifyPassword(httpServletRequest);
            list = l != 0L ? (childChain == null ? Bundler.getAccountBundlers(l) : ((bundler2 = Bundler.getBundler(childChain, l)) == null ? Collections.emptyList() : Collections.singletonList(bundler2))) : (childChain == null ? Bundler.getAllBundlers() : Bundler.getChildChainBundlers(childChain));
        }
        bundler2 = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        list.forEach(bundler -> jSONArray.add((Object)JSONData.bundler(bundler)));
        bundler2.put("bundlers", jSONArray);
        return bundler2;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireFullClient() {
        return true;
    }
}

