/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Chain;
import nxt.blockchain.Transaction;
import nxt.ce.CoinExchange;
import nxt.ce.CoinExchangeTransactionType;
import nxt.ce.OrderCancelAttachment;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetCoinExchangeOrders
extends APIServlet.APIRequestHandler {
    static final GetCoinExchangeOrders instance = new GetCoinExchangeOrders();

    private GetCoinExchangeOrders() {
        super(new APITag[]{APITag.CE}, "exchange", "account", "firstIndex", "lastIndex", "showExpectedCancellations");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Object object;
        Iterable<Object> iterable;
        JSONArray jSONArray;
        Chain chain = ParameterParser.getChain(httpServletRequest, "chain", false);
        int n = chain != null ? chain.getId() : 0;
        Chain chain2 = ParameterParser.getChain(httpServletRequest, "exchange", false);
        int n2 = chain2 != null ? chain2.getId() : 0;
        long l = ParameterParser.getAccountId(httpServletRequest, "account", false);
        int n3 = ParameterParser.getFirstIndex(httpServletRequest);
        int n4 = ParameterParser.getLastIndex(httpServletRequest);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("showExpectedCancellations"));
        long[] lArray = null;
        if (bl) {
            jSONArray = transaction -> transaction.getType() == CoinExchangeTransactionType.ORDER_CANCEL && (chain == null || transaction.getChain() == chain);
            iterable = Nxt.getBlockchain().getExpectedTransactions((Filter<Transaction>)jSONArray);
            lArray = new long[iterable.size()];
            for (int i = 0; i < iterable.size(); ++i) {
                object = (OrderCancelAttachment)((Transaction)iterable.get(i)).getAttachment();
                lArray[i] = ((OrderCancelAttachment)object).getOrderId();
            }
            Arrays.sort(lArray);
        }
        jSONArray = new JSONArray();
        iterable = CoinExchange.getOrders(l, n, n2, n3, n4);
        Throwable throwable = null;
        try {
            while (((DbIterator)iterable).hasNext()) {
                object = (CoinExchange.Order)((DbIterator)iterable).next();
                JSONObject jSONObject = JSONData.coinExchangeOrder((CoinExchange.Order)object);
                if (bl && Arrays.binarySearch(lArray, ((CoinExchange.Order)object).getId()) >= 0) {
                    jSONObject.put((Object)"expectedCancellation", (Object)Boolean.TRUE);
                }
                jSONArray.add((Object)jSONObject);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (iterable != null) {
                if (throwable != null) {
                    try {
                        ((DbIterator)iterable).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((DbIterator)iterable).close();
                }
            }
        }
        iterable = new JSONObject();
        iterable.put("orders", jSONArray);
        return iterable;
    }
}

