/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.lightcontracts.ContractReference;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetContractReferences
extends APIServlet.APIRequestHandler {
    static final GetContractReferences instance = new GetContractReferences();

    private GetContractReferences() {
        super(new APITag[]{APITag.ACCOUNTS}, "account", "contractName", "includeContract", "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getAccountId(httpServletRequest, "account", true);
        String string = Convert.emptyToNull(httpServletRequest.getParameter("contractName"));
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeContract"));
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        jSONObject.put((Object)"contractReferences", (Object)jSONArray);
        JSONData.putAccount(jSONObject, "account", l);
        try (DbIterator<ContractReference> dbIterator = ContractReference.getContractReferences(l, string, n, n2);){
            while (dbIterator.hasNext()) {
                jSONArray.add((Object)JSONData.contractReference(dbIterator.next(), bl));
            }
        }
        return jSONObject;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

