/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.blockchain.ChildChain;
import nxt.db.DbIterator;
import nxt.dgs.DigitalGoodsHome;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetDGSExpiredPurchases
extends APIServlet.APIRequestHandler {
    static final GetDGSExpiredPurchases instance = new GetDGSExpiredPurchases();

    private GetDGSExpiredPurchases() {
        super(new APITag[]{APITag.DGS}, "seller", "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getAccountId(httpServletRequest, "seller", true);
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        try (DbIterator<DigitalGoodsHome.Purchase> dbIterator = childChain.getDigitalGoodsHome().getExpiredSellerPurchases(l, n, n2);){
            while (dbIterator.hasNext()) {
                jSONArray.add((Object)JSONData.purchase(dbIterator.next()));
            }
        }
        jSONObject.put((Object)"purchases", (Object)jSONArray);
        return jSONObject;
    }
}

