/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.blockchain.ChildChain;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.ms.ExchangeHome;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetExchangesByExchangeRequest
extends APIServlet.APIRequestHandler {
    static final GetExchangesByExchangeRequest instance = new GetExchangesByExchangeRequest();

    private GetExchangesByExchangeRequest() {
        super(new APITag[]{APITag.MS}, "transaction", "includeCurrencyInfo");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("transaction"));
        if (string == null) {
            return JSONResponses.MISSING_TRANSACTION;
        }
        long l = Convert.parseUnsignedLong(string);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeCurrencyInfo"));
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        try (DbIterator<ExchangeHome.Exchange> dbIterator = childChain.getExchangeHome().getExchanges(l);){
            while (dbIterator.hasNext()) {
                jSONArray.add((Object)JSONData.exchange(dbIterator.next(), bl));
            }
        }
        jSONObject.put((Object)"exchanges", (Object)jSONArray);
        return jSONObject;
    }
}

