/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.blockchain.ChildChain;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.ms.ExchangeHome;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetExchangesByOffer
extends APIServlet.APIRequestHandler {
    static final GetExchangesByOffer instance = new GetExchangesByOffer();

    private GetExchangesByOffer() {
        super(new APITag[]{APITag.MS}, "offer", "includeCurrencyInfo", "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        long l;
        String string = Convert.emptyToNull(httpServletRequest.getParameter("offer"));
        if (string == null) {
            throw new ParameterException(JSONResponses.MISSING_OFFER);
        }
        try {
            l = Convert.parseUnsignedLong(string);
        }
        catch (RuntimeException runtimeException) {
            throw new ParameterException(JSONResponses.INCORRECT_OFFER);
        }
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeCurrencyInfo"));
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        try (DbIterator<ExchangeHome.Exchange> dbIterator = childChain.getExchangeHome().getOfferExchanges(l, n, n2);){
            while (dbIterator.hasNext()) {
                jSONArray.add((Object)JSONData.exchange(dbIterator.next(), bl));
            }
        }
        jSONObject.put((Object)"exchanges", (Object)jSONArray);
        return jSONObject;
    }
}

