/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.ae.AssetDeleteAttachment;
import nxt.ae.AssetExchangeTransactionType;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetExpectedAssetDeletes
extends APIServlet.APIRequestHandler {
    static final GetExpectedAssetDeletes instance = new GetExpectedAssetDeletes();

    private GetExpectedAssetDeletes() {
        super(new APITag[]{APITag.AE}, "asset", "account", "includeAssetInfo");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "asset", false);
        long l2 = ParameterParser.getAccountId(httpServletRequest, "account", false);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest, false);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeAssetInfo"));
        Filter<Transaction> filter = transaction -> {
            if (transaction.getType() != AssetExchangeTransactionType.ASSET_DELETE) {
                return false;
            }
            if (l2 != 0L && transaction.getSenderId() != l2) {
                return false;
            }
            if (childChain != null && transaction.getChain() != childChain) {
                return false;
            }
            AssetDeleteAttachment assetDeleteAttachment = (AssetDeleteAttachment)transaction.getAttachment();
            return l == 0L || assetDeleteAttachment.getAssetId() == l;
        };
        List<? extends Transaction> list = Nxt.getBlockchain().getExpectedTransactions(filter);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        list.forEach(transaction -> jSONArray.add((Object)JSONData.expectedAssetDelete(transaction, bl)));
        jSONObject.put((Object)"deletes", (Object)jSONArray);
        return jSONObject;
    }
}

