/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.ae.AssetExchangeTransactionType;
import nxt.ae.OrderPlacementAttachment;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetExpectedBidOrders
extends APIServlet.APIRequestHandler {
    static final GetExpectedBidOrders instance = new GetExpectedBidOrders();
    private final Comparator<Transaction> priceComparator = (transaction, transaction2) -> {
        OrderPlacementAttachment orderPlacementAttachment = (OrderPlacementAttachment)transaction.getAttachment();
        OrderPlacementAttachment orderPlacementAttachment2 = (OrderPlacementAttachment)transaction2.getAttachment();
        return Long.compare(orderPlacementAttachment2.getPriceNQT(), orderPlacementAttachment.getPriceNQT());
    };

    private GetExpectedBidOrders() {
        super(new APITag[]{APITag.AE}, "asset", "sortByPrice");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "asset", false);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest, false);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("sortByPrice"));
        Filter<Transaction> filter = transaction -> {
            if (transaction.getType() != AssetExchangeTransactionType.BID_ORDER_PLACEMENT) {
                return false;
            }
            if (childChain != null && transaction.getChain() != childChain) {
                return false;
            }
            OrderPlacementAttachment orderPlacementAttachment = (OrderPlacementAttachment)transaction.getAttachment();
            return l == 0L || orderPlacementAttachment.getAssetId() == l;
        };
        List<? extends Transaction> list = Nxt.getBlockchain().getExpectedTransactions(filter);
        if (bl) {
            list.sort(this.priceComparator);
        }
        JSONArray jSONArray = new JSONArray();
        list.forEach(transaction -> jSONArray.add((Object)JSONData.expectedBidOrder(transaction)));
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"bidOrders", (Object)jSONArray);
        return jSONObject;
    }
}

