/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Chain;
import nxt.blockchain.Transaction;
import nxt.ce.CoinExchangeFxtTransactionType;
import nxt.ce.CoinExchangeTransactionType;
import nxt.ce.OrderIssueAttachment;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetExpectedCoinExchangeOrders
extends APIServlet.APIRequestHandler {
    static final GetExpectedCoinExchangeOrders instance = new GetExpectedCoinExchangeOrders();

    private GetExpectedCoinExchangeOrders() {
        super(new APITag[]{APITag.CE}, "exchange", "account");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Chain chain = ParameterParser.getChain(httpServletRequest, "chain", false);
        Chain chain2 = ParameterParser.getChain(httpServletRequest, "exchange", false);
        long l = ParameterParser.getAccountId(httpServletRequest, "account", false);
        Filter<Transaction> filter = transaction -> {
            if (transaction.getType() != CoinExchangeFxtTransactionType.ORDER_ISSUE && transaction.getType() != CoinExchangeTransactionType.ORDER_ISSUE) {
                return false;
            }
            if (l != 0L && transaction.getSenderId() != l) {
                return false;
            }
            OrderIssueAttachment orderIssueAttachment = (OrderIssueAttachment)transaction.getAttachment();
            return !(chain != null && chain != orderIssueAttachment.getChain() || chain2 != null && chain2 != orderIssueAttachment.getExchangeChain());
        };
        List<? extends Transaction> list = Nxt.getBlockchain().getExpectedTransactions(filter);
        JSONArray jSONArray = new JSONArray();
        list.forEach(transaction -> jSONArray.add((Object)JSONData.expectedCoinExchangeOrder(transaction)));
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"orders", (Object)jSONArray);
        return jSONObject;
    }
}

