/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.blockchain.ChildChain;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.shuffling.ShufflingHome;
import nxt.shuffling.ShufflingStage;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetHoldingShufflings
extends APIServlet.APIRequestHandler {
    static final GetHoldingShufflings instance = new GetHoldingShufflings();

    private GetHoldingShufflings() {
        super(new APITag[]{APITag.SHUFFLING}, "holding", "stage", "includeFinished", "firstIndex", "lastIndex");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        long l = 0L;
        String string = Convert.emptyToNull(httpServletRequest.getParameter("holding"));
        if (string != null) {
            try {
                l = Convert.parseUnsignedLong(string);
            }
            catch (RuntimeException runtimeException) {
                return JSONResponses.incorrect("holding");
            }
        }
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter("stage"));
        ShufflingStage shufflingStage = null;
        if (string2 != null) {
            try {
                shufflingStage = ShufflingStage.get(Byte.parseByte(string2));
            }
            catch (RuntimeException runtimeException) {
                return JSONResponses.incorrect("stage");
            }
        }
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeFinished"));
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        jSONObject.put((Object)"shufflings", (Object)jSONArray);
        try (DbIterator<ShufflingHome.Shuffling> dbIterator = childChain.getShufflingHome().getHoldingShufflings(l, shufflingStage, bl, n, n2);){
            for (ShufflingHome.Shuffling shuffling : dbIterator) {
                jSONArray.add((Object)JSONData.shuffling(shuffling, false));
            }
        }
        return jSONObject;
    }
}

