/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.crypto.Crypto;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetSharedKey
extends APIServlet.APIRequestHandler {
    static final GetSharedKey instance = new GetSharedKey();

    private GetSharedKey() {
        super(new APITag[]{APITag.MESSAGES}, "account", "secretPhrase", "nonce");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        String string = ParameterParser.getSecretPhrase(httpServletRequest, true);
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "nonce", true);
        long l = ParameterParser.getAccountId(httpServletRequest, "account", true);
        byte[] byArray2 = Account.getPublicKey(l);
        if (byArray2 == null) {
            return JSONResponses.INCORRECT_ACCOUNT;
        }
        byte[] byArray3 = Crypto.getSharedKey(Crypto.getPrivateKey(string), byArray2, byArray);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"sharedKey", (Object)Convert.toHexString(byArray3));
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

