/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.ms.Currency;
import nxt.ms.PublishExchangeOfferAttachment;
import org.json.simple.JSONStreamAware;

public final class PublishExchangeOffer
extends CreateTransaction {
    static final PublishExchangeOffer instance = new PublishExchangeOffer();

    private PublishExchangeOffer() {
        super(new APITag[]{APITag.MS, APITag.CREATE_TRANSACTION}, "currency", "buyRateNQTPerUnit", "sellRateNQTPerUnit", "totalBuyLimitQNT", "totalSellLimitQNT", "initialBuySupplyQNT", "initialSellSupplyQNT", "expirationHeight");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Currency currency = ParameterParser.getCurrency(httpServletRequest);
        long l = ParameterParser.getLong(httpServletRequest, "buyRateNQTPerUnit", 1L, 100000000000000000L, true);
        long l2 = ParameterParser.getLong(httpServletRequest, "sellRateNQTPerUnit", 1L, 100000000000000000L, true);
        long l3 = ParameterParser.getLong(httpServletRequest, "totalBuyLimitQNT", 0L, 100000000000000000L, true);
        long l4 = ParameterParser.getLong(httpServletRequest, "totalSellLimitQNT", 0L, 100000000000000000L, true);
        long l5 = ParameterParser.getLong(httpServletRequest, "initialBuySupplyQNT", 0L, 100000000000000000L, true);
        long l6 = ParameterParser.getLong(httpServletRequest, "initialSellSupplyQNT", 0L, 100000000000000000L, true);
        int n = ParameterParser.getInt(httpServletRequest, "expirationHeight", 0, Integer.MAX_VALUE, true);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        PublishExchangeOfferAttachment publishExchangeOfferAttachment = new PublishExchangeOfferAttachment(currency.getId(), l, l2, l3, l4, l5, l6, n);
        try {
            return this.createTransaction(httpServletRequest, account, publishExchangeOfferAttachment);
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_FUNDS;
        }
    }
}

