/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.ChainTransactionId;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.lightcontracts.ContractReferenceAttachment;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class SetContractReference
extends CreateTransaction {
    static final SetContractReference instance = new SetContractReference();

    private SetContractReference() {
        super(new APITag[]{APITag.ACCOUNTS, APITag.CREATE_TRANSACTION}, "contractName", "contractParams", "contract");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        String string = Convert.nullToEmpty(httpServletRequest.getParameter("contractName")).trim();
        String string2 = Convert.nullToEmpty(httpServletRequest.getParameter("contractParams")).trim();
        if (string.length() > 32 || string.length() == 0) {
            return JSONResponses.INCORRECT_CONTRACT_NAME_LENGTH;
        }
        if (string2.length() > 160) {
            return JSONResponses.INCORRECT_CONTRACT_PARAMS_LENGTH;
        }
        ChainTransactionId chainTransactionId = ParameterParser.getChainTransactionId(httpServletRequest, "contract");
        ContractReferenceAttachment contractReferenceAttachment = new ContractReferenceAttachment(string, string2, chainTransactionId);
        return this.createTransaction(httpServletRequest, account, contractReferenceAttachment);
    }

    @Override
    public boolean isIgnisOnly() {
        return true;
    }
}

