/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.HoldingType;
import nxt.blockchain.ChildChain;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.shuffling.ShufflingCreationAttachment;
import org.json.simple.JSONStreamAware;

public final class ShufflingCreate
extends CreateTransaction {
    static final ShufflingCreate instance = new ShufflingCreate();

    private ShufflingCreate() {
        super(new APITag[]{APITag.SHUFFLING, APITag.CREATE_TRANSACTION}, "holding", "holdingType", "amount", "participantCount", "registrationPeriod");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        HoldingType holdingType = ParameterParser.getHoldingType(httpServletRequest);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        long l = holdingType != HoldingType.COIN ? ParameterParser.getHoldingId(httpServletRequest) : (long)childChain.getId();
        long l2 = ParameterParser.getLong(httpServletRequest, "amount", 0L, Long.MAX_VALUE, true);
        if (holdingType == HoldingType.COIN && l2 < childChain.SHUFFLING_DEPOSIT_NQT) {
            return JSONResponses.incorrect("amount", String.format("Minimum shuffling amount is %f %s", (double)childChain.SHUFFLING_DEPOSIT_NQT / (double)childChain.ONE_COIN, childChain.getName()));
        }
        byte by = ParameterParser.getByte(httpServletRequest, "participantCount", (byte)3, (byte)30, true);
        short s = (short)ParameterParser.getInt(httpServletRequest, "registrationPeriod", 0, 10080, true);
        ShufflingCreationAttachment shufflingCreationAttachment = new ShufflingCreationAttachment(l, holdingType, l2, by, s);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        if (account.getControls().contains((Object)Account.ControlType.PHASING_ONLY)) {
            return JSONResponses.error("Accounts under phasing only control cannot start a shuffling");
        }
        try {
            return this.createTransaction(httpServletRequest, account, shufflingCreationAttachment);
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.notEnoughHolding(holdingType);
        }
    }
}

