/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.shuffling.ShufflingHome;
import nxt.shuffling.ShufflingVerificationAttachment;
import org.json.simple.JSONStreamAware;

public final class ShufflingVerify
extends CreateTransaction {
    static final ShufflingVerify instance = new ShufflingVerify();

    private ShufflingVerify() {
        super(new APITag[]{APITag.SHUFFLING, APITag.CREATE_TRANSACTION}, "shufflingFullHash", "shufflingStateHash");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        ShufflingHome.Shuffling shuffling = ParameterParser.getShuffling(httpServletRequest);
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "shufflingStateHash", true);
        if (!Arrays.equals(byArray, shuffling.getStateHash())) {
            return JSONResponses.incorrect("shufflingStateHash", "Shuffling is in a different state now");
        }
        ShufflingVerificationAttachment shufflingVerificationAttachment = new ShufflingVerificationAttachment(shuffling.getFullHash(), byArray);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        return this.createTransaction(httpServletRequest, account, shufflingVerificationAttachment);
    }
}

