/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.blockchain.Chain;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class SimulateCoinExchange
extends APIServlet.APIRequestHandler {
    static final SimulateCoinExchange instance = new SimulateCoinExchange();

    private SimulateCoinExchange() {
        super(new APITag[]{APITag.CE}, "exchange", "quantityQNT", "priceNQTPerCoin");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Chain chain;
        Chain chain2 = ParameterParser.getChain(httpServletRequest, "chain", true);
        if (chain2 == (chain = ParameterParser.getChain(httpServletRequest, "exchange", true))) {
            return JSONResponses.incorrect("exchange", "exchange must specify a different chain");
        }
        long l = ParameterParser.getQuantityQNT(httpServletRequest);
        long l2 = ParameterParser.getPriceNQTPerCoin(httpServletRequest);
        long l3 = Convert.unitRateToAmount(l, chain.getDecimals(), l2, chain2.getDecimals());
        if (l3 == 0L) {
            return JSONResponses.NO_COST_ORDER;
        }
        long l4 = BigDecimal.ONE.divide(new BigDecimal(l2).movePointLeft(chain2.getDecimals()), MathContext.DECIMAL128).movePointRight(chain.getDecimals()).longValue();
        if (l4 == 0L) {
            return JSONResponses.NO_COST_ORDER;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"quantityQNT", (Object)l);
        jSONObject.put((Object)"bidNQTPerCoin", (Object)l2);
        jSONObject.put((Object)"askNQTPerCoin", (Object)l4);
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }
}

