/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.account.Account;
import nxt.crypto.Crypto;
import nxt.http.API;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.shuffling.Shuffler;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class StopShuffler
extends APIServlet.APIRequestHandler {
    static final StopShuffler instance = new StopShuffler();

    private StopShuffler() {
        super(new APITag[]{APITag.SHUFFLING}, "account", "shufflingFullHash", "secretPhrase", "adminPassword");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        String string = ParameterParser.getSecretPhrase(httpServletRequest, false);
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "shufflingFullHash", false);
        long l = ParameterParser.getAccountId(httpServletRequest, false);
        JSONObject jSONObject = new JSONObject();
        if (string != null) {
            if (l != 0L && Account.getId(Crypto.getPublicKey(string)) != l) {
                return JSONResponses.INCORRECT_ACCOUNT;
            }
            l = Account.getId(Crypto.getPublicKey(string));
            if (byArray.length == 0) {
                return JSONResponses.missing("shufflingFullHash");
            }
            Shuffler shuffler = Shuffler.stopShuffler(l, byArray);
            jSONObject.put((Object)"stoppedShuffler", (Object)(shuffler != null ? 1 : 0));
        } else {
            API.verifyPassword(httpServletRequest);
            if (l != 0L && byArray.length != 0) {
                Shuffler shuffler = Shuffler.stopShuffler(l, byArray);
                jSONObject.put((Object)"stoppedShuffler", (Object)(shuffler != null ? 1 : 0));
            } else if (l == 0L && byArray.length == 0) {
                Shuffler.stopAllShufflers();
                jSONObject.put((Object)"stoppedAllShufflers", (Object)true);
            } else {
                if (l != 0L) {
                    return JSONResponses.missing("shufflingFullHash");
                }
                if (byArray.length != 0) {
                    return JSONResponses.missing("account");
                }
            }
        }
        return jSONObject;
    }

    @Override
    protected boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireFullClient() {
        return true;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

