/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.responses;

import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import nxt.addons.JA;
import nxt.addons.JO;
import nxt.blockchain.ChainTransactionId;
import nxt.http.responses.BlockResponse;
import nxt.http.responses.TransactionResponse;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public class BlockResponseImpl
implements BlockResponse {
    private long blockId;
    private int height;
    private long generatorId;
    private byte[] generatorPublicKey;
    private int timestamp;
    private int numberOfTransactions;
    private long totalFeeFQT;
    private byte version;
    private long baseTarget;
    private BigInteger cumulativeDifficulty;
    private long previousBlockId;
    private long nextBlockId;
    private byte[] payloadHash;
    private byte[] generationSignature;
    private byte[] previousBlockHash;
    private byte[] blockSignature;
    private List<byte[]> parentTransactionFullHashes;
    private List<TransactionResponse> parentTransactions;
    private List<ChainTransactionId> executedPhasedTransactionIds;
    private List<TransactionResponse> executedPhasedTransactions;

    public BlockResponseImpl(JSONObject jSONObject) {
        this(new JO(jSONObject));
    }

    public BlockResponseImpl(JO jO2) {
        List<Object> list;
        this.blockId = jO2.getEntityId("block");
        this.height = jO2.getInt("height");
        this.generatorId = jO2.getEntityId("generator");
        this.generatorPublicKey = jO2.parseHexString("generatorPublicKey");
        this.timestamp = jO2.getInt("timestamp");
        this.numberOfTransactions = jO2.getInt("numberOfTransactions");
        if (jO2.isExist("totalFeeFQT")) {
            this.totalFeeFQT = jO2.getLong("totalFeeFQT");
        }
        this.version = jO2.getByte("version");
        this.baseTarget = jO2.getLong("baseTarget");
        this.cumulativeDifficulty = new BigInteger(jO2.getString("cumulativeDifficulty"));
        if (jO2.isExist("previousBlock")) {
            this.previousBlockId = jO2.getEntityId("previousBlock");
        }
        if (jO2.isExist("nextBlock")) {
            this.nextBlockId = jO2.getEntityId("nextBlock");
        }
        this.payloadHash = jO2.parseHexString("payloadHash");
        this.generationSignature = jO2.parseHexString("generationSignature");
        this.previousBlockHash = jO2.parseHexString("previousBlockHash");
        this.blockSignature = jO2.parseHexString("blockSignature");
        if (jO2.isExist("transactions") && ((JA)(list = jO2.getArray("parentTransactions"))).size() > 0) {
            if (((JA)list).getObject(0) instanceof String) {
                this.parentTransactionFullHashes = ((JA)list).values().stream().map(Convert::parseHexString).collect(Collectors.toList());
            } else {
                this.parentTransactions = ((JA)list).objects().stream().map(TransactionResponse::create).collect(Collectors.toList());
            }
        }
        if (jO2.isExist("transactions") && ((JA)(list = jO2.getArray("transactions"))).size() > 0) {
            if (((JA)list).getObject(0) instanceof String) {
                this.parentTransactionFullHashes = ((JA)list).values().stream().map(Convert::parseHexString).collect(Collectors.toList());
            } else {
                this.parentTransactions = ((JA)list).objects().stream().map(TransactionResponse::create).collect(Collectors.toList());
            }
        }
        if (jO2.isExist("executedPhasedTransactions") && (list = jO2.getJoList("executedPhasedTransactions")).size() > 0) {
            if (((JO)list.get(0)).isExist("chain")) {
                this.executedPhasedTransactionIds = list.stream().map(jO -> new ChainTransactionId(jO.getInt("chain"), jO.parseHexString("transactionFullHash"))).collect(Collectors.toList());
            } else {
                this.executedPhasedTransactions = list.stream().map(TransactionResponse::create).collect(Collectors.toList());
            }
        }
    }

    @Override
    public long getBlockId() {
        return this.blockId;
    }

    @Override
    public String getBlock() {
        return Long.toUnsignedString(this.blockId);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public long getGeneratorId() {
        return this.generatorId;
    }

    @Override
    public String getGenerator() {
        return Long.toUnsignedString(this.generatorId);
    }

    @Override
    public String getGeneratorRs() {
        return Convert.rsAccount(this.generatorId);
    }

    @Override
    public byte[] getGeneratorPublicKey() {
        return this.generatorPublicKey;
    }

    @Override
    public int getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getNumberOfTransactions() {
        return this.numberOfTransactions;
    }

    @Override
    public long getTotalFeeFQT() {
        return this.totalFeeFQT;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public long getBaseTarget() {
        return this.baseTarget;
    }

    @Override
    public BigInteger getCumulativeDifficulty() {
        return this.cumulativeDifficulty;
    }

    @Override
    public long getPreviousBlockId() {
        return this.previousBlockId;
    }

    @Override
    public String getPreviousBlock() {
        return Long.toUnsignedString(this.previousBlockId);
    }

    @Override
    public long getNextBlockId() {
        return this.nextBlockId;
    }

    @Override
    public String getNextBlock() {
        return Long.toUnsignedString(this.nextBlockId);
    }

    @Override
    public byte[] getPayloadHash() {
        return this.payloadHash;
    }

    @Override
    public byte[] getGenerationSignature() {
        return this.generationSignature;
    }

    @Override
    public byte[] getPreviousBlockHash() {
        return this.previousBlockHash;
    }

    @Override
    public byte[] getBlockSignature() {
        return this.blockSignature;
    }

    @Override
    public List<byte[]> getParentTransactionFullHashes() {
        return this.parentTransactionFullHashes;
    }

    @Override
    public List<TransactionResponse> getParentTransactions() {
        return this.parentTransactions;
    }

    @Override
    public List<ChainTransactionId> getExecutedPhasedTransactionIds() {
        return this.executedPhasedTransactionIds;
    }

    @Override
    public List<TransactionResponse> getExecutedPhasedTransactions() {
        return this.executedPhasedTransactions;
    }
}

