/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.responses;

import nxt.addons.JO;
import nxt.http.responses.CoinExchangeTradeResponse;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public class CoinExchangeTradeResponseImpl
implements CoinExchangeTradeResponse {
    private final byte[] orderFullHash;
    private final byte[] matchFullHash;
    private final int chainId;
    private final int exchangeChainId;
    private final long accountId;
    private final long quantityQNT;
    private final long priceNQTPerCoin;
    private final double exchangeRate;
    private final long blockId;
    private final int height;
    private final int timestamp;

    CoinExchangeTradeResponseImpl(JSONObject jSONObject) {
        this(new JO(jSONObject));
    }

    CoinExchangeTradeResponseImpl(JO jO) {
        this.orderFullHash = jO.parseHexString("orderFullHash");
        this.matchFullHash = jO.parseHexString("matchFullHash");
        this.chainId = jO.getInt("chain");
        this.exchangeChainId = jO.getInt("exchange");
        this.accountId = jO.getEntityId("account");
        this.quantityQNT = jO.getLong("quantityQNT");
        this.priceNQTPerCoin = jO.getLong("priceNQTPerCoin");
        this.exchangeRate = jO.getDouble("exchangeRate");
        this.timestamp = jO.getInt("timestamp");
        this.blockId = jO.getEntityId("block");
        this.height = jO.getInt("height");
    }

    @Override
    public byte[] getOrderFullHash() {
        return this.orderFullHash;
    }

    @Override
    public byte[] getMatchFullHash() {
        return this.matchFullHash;
    }

    @Override
    public int getChainId() {
        return this.chainId;
    }

    @Override
    public int getExchangeChainId() {
        return this.exchangeChainId;
    }

    @Override
    public long getAccountId() {
        return this.accountId;
    }

    @Override
    public String getAccount() {
        return Long.toUnsignedString(this.accountId);
    }

    @Override
    public String getAccountRs() {
        if (this.accountId == 0L) {
            return null;
        }
        return Convert.rsAccount(this.accountId);
    }

    @Override
    public long getQuantityQNT() {
        return this.quantityQNT;
    }

    @Override
    public long getPriceNQTPerCoin() {
        return this.priceNQTPerCoin;
    }

    @Override
    public double getExchangeRate() {
        return this.exchangeRate;
    }

    @Override
    public long getBlockId() {
        return this.blockId;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getTimestamp() {
        return this.timestamp;
    }
}

