/*
 * Decompiled with CFR 0.152.
 */
package nxt.lightcontracts;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Nxt;
import nxt.account.Account;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.VersionedEntityDbTable;
import nxt.util.Convert;
import nxt.util.Listener;
import nxt.util.Listeners;

public final class ContractReference {
    private static final Listeners<ContractReference, Event> listeners = new Listeners();
    private static final DbKey.LongKeyFactory<ContractReference> contractReferenceDbKeyFactory = new DbKey.LongKeyFactory<ContractReference>("id"){

        @Override
        public DbKey newKey(ContractReference contractReference) {
            return contractReference.dbKey;
        }
    };
    private static final VersionedEntityDbTable<ContractReference> contractReferenceTable = new VersionedEntityDbTable<ContractReference>("public.contract_reference", contractReferenceDbKeyFactory){

        @Override
        protected ContractReference load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
            return new ContractReference(resultSet, dbKey);
        }

        @Override
        protected void save(Connection connection, ContractReference contractReference) throws SQLException {
            contractReference.save(connection);
        }
    };
    private final long id;
    private final DbKey dbKey;
    private final long accountId;
    private final String contractName;
    private String contractParams;
    private ChainTransactionId contractId;

    public static boolean addListener(Listener<ContractReference> listener, Event event) {
        return listeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<ContractReference> listener, Event event) {
        return listeners.removeListener(listener, event);
    }

    public static ContractReference getContractReference(long l) {
        return (ContractReference)contractReferenceTable.get(contractReferenceDbKeyFactory.newKey(l));
    }

    public static ContractReference getContractReference(long l, String string) {
        DbClause dbClause = new DbClause.LongClause("account_id", l);
        dbClause = dbClause.and(new DbClause.StringClause("contract_name", string));
        return (ContractReference)contractReferenceTable.getBy(dbClause);
    }

    public static DbIterator<ContractReference> getContractReferences(long l, String string, int n, int n2) {
        DbClause dbClause = new DbClause.LongClause("account_id", l);
        if (string != null) {
            dbClause = dbClause.and(new DbClause.StringClause("contract_name", string));
        }
        return contractReferenceTable.getManyBy(dbClause, n, n2, " ORDER BY contract_name ");
    }

    static void setContractReference(Transaction transaction, Account account, String string, String string2, ChainTransactionId chainTransactionId) {
        string2 = Convert.emptyToNull(string2);
        ContractReference contractReference = ContractReference.getContractReference(account.getId(), string);
        if (contractReference == null) {
            contractReference = new ContractReference(transaction.getId(), account.getId(), string, string2, chainTransactionId);
        } else {
            contractReference.contractParams = string2;
            contractReference.contractId = chainTransactionId;
        }
        contractReferenceTable.insert(contractReference);
        listeners.notify(contractReference, Event.SET_CONTRACT_REFERENCE);
    }

    static void deleteContractReference(long l) {
        ContractReference contractReference = (ContractReference)contractReferenceTable.get(contractReferenceDbKeyFactory.newKey(l));
        if (contractReference == null) {
            return;
        }
        contractReferenceTable.delete(contractReference);
        listeners.notify(contractReference, Event.DELETE_CONTRACT_REFERENCE);
    }

    public static void init() {
    }

    private ContractReference(long l, long l2, String string, String string2, ChainTransactionId chainTransactionId) {
        this.id = l;
        this.dbKey = contractReferenceDbKeyFactory.newKey(this.id);
        this.accountId = l2;
        this.contractName = string;
        this.contractParams = string2;
        this.contractId = chainTransactionId;
    }

    private ContractReference(ResultSet resultSet, DbKey dbKey) throws SQLException {
        this.id = resultSet.getLong("id");
        this.dbKey = dbKey;
        this.accountId = resultSet.getLong("account_id");
        this.contractName = resultSet.getString("contract_name");
        this.contractParams = resultSet.getString("contract_params");
        this.contractId = new ChainTransactionId(resultSet.getInt("contract_transaction_chain_id"), resultSet.getBytes("contract_transaction_full_hash"));
    }

    private void save(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO contract_reference (id, account_id, contract_name, contract_params, contract_transaction_chain_id, contract_transaction_full_hash, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, TRUE)");){
            int n = 0;
            preparedStatement.setLong(++n, this.id);
            preparedStatement.setLong(++n, this.accountId);
            DbUtils.setString(preparedStatement, ++n, this.contractName);
            DbUtils.setString(preparedStatement, ++n, this.contractParams);
            preparedStatement.setInt(++n, this.contractId.getChainId());
            preparedStatement.setBytes(++n, this.contractId.getFullHash());
            preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
            preparedStatement.executeUpdate();
        }
    }

    public long getId() {
        return this.id;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public String getContractName() {
        return this.contractName;
    }

    public String getContractParams() {
        return this.contractParams;
    }

    public ChainTransactionId getContractId() {
        return this.contractId;
    }

    public static enum Event {
        SET_CONTRACT_REFERENCE,
        DELETE_CONTRACT_REFERENCE;

    }
}

