/*
 * Decompiled with CFR 0.152.
 */
package nxt.lightcontracts;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.lightcontracts.LightContractTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class ContractReferenceDeleteAttachment
extends Attachment.AbstractAttachment {
    private final long contractReferenceId;

    ContractReferenceDeleteAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.contractReferenceId = byteBuffer.getLong();
    }

    ContractReferenceDeleteAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.contractReferenceId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"contractReference"));
    }

    public ContractReferenceDeleteAttachment(long l) {
        this.contractReferenceId = l;
    }

    @Override
    protected int getMySize() {
        return 8;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.contractReferenceId);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"contractReference", (Object)Long.toUnsignedString(this.contractReferenceId));
    }

    @Override
    public TransactionType getTransactionType() {
        return LightContractTransactionType.CONTRACT_REFERENCE_DELETE;
    }

    public long getContractReferenceId() {
        return this.contractReferenceId;
    }
}

