/*
 * Decompiled with CFR 0.152.
 */
package nxt.messaging;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.blockchain.Appendix;
import nxt.blockchain.Transaction;
import nxt.crypto.EncryptedData;
import nxt.messaging.AbstractEncryptedMessageAppendix;
import nxt.messaging.UnencryptedEncryptedMessageAppendix;
import org.json.simple.JSONObject;

public class EncryptedMessageAppendix
extends AbstractEncryptedMessageAppendix {
    public static final int appendixType = 2;
    public static final String appendixName = "EncryptedMessage";
    public static final Appendix.Parser appendixParser = new Appendix.Parser(){

        @Override
        public Appendix.AbstractAppendix parse(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new EncryptedMessageAppendix(byteBuffer);
        }

        @Override
        public Appendix.AbstractAppendix parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(EncryptedMessageAppendix.appendixName, jSONObject)) {
                return null;
            }
            if (((JSONObject)jSONObject.get((Object)"encryptedMessage")).get((Object)"data") == null) {
                return new UnencryptedEncryptedMessageAppendix(jSONObject);
            }
            return new EncryptedMessageAppendix(jSONObject);
        }
    };

    private EncryptedMessageAppendix(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
    }

    EncryptedMessageAppendix(JSONObject jSONObject) {
        super(jSONObject, (JSONObject)jSONObject.get((Object)"encryptedMessage"));
    }

    public EncryptedMessageAppendix(EncryptedData encryptedData, boolean bl, boolean bl2) {
        super(encryptedData, bl, bl2);
    }

    @Override
    public int getAppendixType() {
        return 2;
    }

    @Override
    public final String getAppendixName() {
        return appendixName;
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        super.putMyJSON(jSONObject2);
        jSONObject.put((Object)"encryptedMessage", (Object)jSONObject2);
    }

    @Override
    public void validate(Transaction transaction) throws NxtException.ValidationException {
        super.validate(transaction);
        if (transaction.getRecipientId() == 0L) {
            throw new NxtException.NotValidException("Encrypted messages cannot be attached to transactions with no recipient");
        }
    }
}

