/*
 * Decompiled with CFR 0.152.
 */
package nxt.messaging;

import java.nio.ByteBuffer;
import java.util.Arrays;
import nxt.NxtException;
import nxt.account.Account;
import nxt.blockchain.Appendix;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public class MessageAppendix
extends Appendix.AbstractAppendix {
    public static final int appendixType = 1;
    public static final String appendixName = "Message";
    public static final Appendix.Parser appendixParser = new Appendix.Parser(){

        @Override
        public Appendix.AbstractAppendix parse(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new MessageAppendix(byteBuffer);
        }

        @Override
        public Appendix.AbstractAppendix parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(MessageAppendix.appendixName, jSONObject)) {
                return null;
            }
            return new MessageAppendix(jSONObject);
        }
    };
    private static final Fee MESSAGE_FEE = new Fee.SizeBasedFee(0L, 10000000L, 32){

        @Override
        public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
            return ((MessageAppendix)appendix).getMessage().length;
        }
    };
    private final byte[] message;
    private final boolean isText;

    private MessageAppendix(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        byte by = byteBuffer.get();
        this.isText = (by & 1) != 0;
        int n = byteBuffer.getShort() & 0xFFFF;
        if (n > 1000) {
            throw new NxtException.NotValidException("Invalid arbitrary message length: " + n);
        }
        this.message = new byte[n];
        byteBuffer.get(this.message);
        if (this.isText && !Arrays.equals(this.message, Convert.toBytes(Convert.toString(this.message)))) {
            throw new NxtException.NotValidException("Message is not UTF-8 text");
        }
    }

    private MessageAppendix(JSONObject jSONObject) {
        super(jSONObject);
        String string = (String)jSONObject.get((Object)"message");
        this.isText = Boolean.TRUE.equals(jSONObject.get((Object)"messageIsText"));
        this.message = this.isText ? Convert.toBytes(string) : Convert.parseHexString(string);
    }

    public MessageAppendix(byte[] byArray) {
        this(byArray, false);
    }

    public MessageAppendix(String string) {
        this(Convert.toBytes(string), true);
    }

    public MessageAppendix(String string, boolean bl) {
        this(bl ? Convert.toBytes(string) : Convert.parseHexString(string), bl);
    }

    public MessageAppendix(byte[] byArray, boolean bl) {
        this.message = byArray;
        this.isText = bl;
    }

    @Override
    public int getAppendixType() {
        return 1;
    }

    @Override
    public String getAppendixName() {
        return appendixName;
    }

    @Override
    protected int getMySize() {
        return 3 + this.message.length;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byte by = 0;
        if (this.isText) {
            by = (byte)(by | 1);
        }
        byteBuffer.put(by);
        byteBuffer.putShort((short)this.message.length);
        byteBuffer.put(this.message);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"message", (Object)Convert.toString(this.message, this.isText));
        jSONObject.put((Object)"messageIsText", (Object)this.isText);
    }

    @Override
    public Fee getBaselineFee(Transaction transaction) {
        return MESSAGE_FEE;
    }

    @Override
    public void validate(Transaction transaction) throws NxtException.ValidationException {
        if (this.message.length > 160) {
            throw new NxtException.NotValidException("Invalid arbitrary message length: " + this.message.length);
        }
    }

    @Override
    public void apply(Transaction transaction, Account account, Account account2) {
    }

    public byte[] getMessage() {
        return this.message;
    }

    public boolean isText() {
        return this.isText;
    }

    @Override
    public boolean isPhasable() {
        return false;
    }

    @Override
    public boolean isAllowed(Chain chain) {
        return chain instanceof ChildChain;
    }
}

