/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.ms.MonetarySystemAttachment;
import nxt.ms.MonetarySystemTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class CurrencyDeletionAttachment
extends Attachment.AbstractAttachment
implements MonetarySystemAttachment {
    private final long currencyId;

    public CurrencyDeletionAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.currencyId = byteBuffer.getLong();
    }

    public CurrencyDeletionAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.currencyId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"currency"));
    }

    public CurrencyDeletionAttachment(long l) {
        this.currencyId = l;
    }

    @Override
    protected int getMySize() {
        return 8;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.currencyId);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(this.currencyId));
    }

    @Override
    public TransactionType getTransactionType() {
        return MonetarySystemTransactionType.CURRENCY_DELETION;
    }

    @Override
    public long getCurrencyId() {
        return this.currencyId;
    }
}

