/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import nxt.Nxt;
import nxt.account.Account;
import nxt.account.HoldingType;
import nxt.blockchain.Block;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.ChildChain;
import nxt.migration.HoldingMigrateBlockEventHandler;
import nxt.migration.MigrationMonitor;
import nxt.migration.SaveHoldingSnapshotListener;
import nxt.ms.Currency;
import nxt.ms.CurrencySnapshot;
import nxt.util.Listener;
import nxt.util.Logger;

public class CurrencyMigrateMonitor {
    static void init() {
        MigrationMonitor.init();
        Nxt.getBlockchainProcessor().addListener(new HoldingMigrateBlockEventHandler(new CurrencySnapshot()), BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
        Account.addPropertyListener(new AccountPropertyEventHandler(), Account.Event.SET_PROPERTY);
    }

    public static void enableMigration(long l, ChildChain childChain, int n, int n2) {
        MigrationMonitor.enableMigration(l, HoldingType.CURRENCY, childChain, n, n2);
    }

    public static Listener<Block> getSaveCurrencySnapshotListener() {
        return new SaveHoldingSnapshotListener(new CurrencySnapshot());
    }

    private static class AccountPropertyEventHandler
    implements Listener<Account.AccountProperty> {
        private AccountPropertyEventHandler() {
        }

        @Override
        public void notify(Account.AccountProperty accountProperty) {
            long l;
            int n;
            if (!accountProperty.getProperty().startsWith("Migrate")) {
                return;
            }
            if (accountProperty.getSetterId() != accountProperty.getRecipientId()) {
                return;
            }
            try {
                n = Integer.parseInt(accountProperty.getValue());
                l = Long.parseUnsignedLong(accountProperty.getProperty().substring("Migrate".length()));
            }
            catch (NumberFormatException numberFormatException) {
                Logger.logDebugMessage("Invalid height or currencyId value", numberFormatException);
                return;
            }
            Currency currency = Currency.getCurrency(l);
            if (currency == null || currency.getAccountId() != accountProperty.getSetterId()) {
                return;
            }
            MigrationMonitor.scheduleMigration(HoldingType.CURRENCY, l, n);
        }
    }
}

