/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.ms.MonetarySystemAttachment;
import nxt.ms.MonetarySystemTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class ReserveIncreaseAttachment
extends Attachment.AbstractAttachment
implements MonetarySystemAttachment {
    private final long currencyId;
    private final long amountPerUnitNQT;

    public ReserveIncreaseAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.currencyId = byteBuffer.getLong();
        this.amountPerUnitNQT = byteBuffer.getLong();
    }

    public ReserveIncreaseAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.currencyId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"currency"));
        this.amountPerUnitNQT = Convert.parseLong(jSONObject.get((Object)"amountPerUnitNQT"));
    }

    public ReserveIncreaseAttachment(long l, long l2) {
        this.currencyId = l;
        this.amountPerUnitNQT = l2;
    }

    @Override
    protected int getMySize() {
        return 16;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.currencyId);
        byteBuffer.putLong(this.amountPerUnitNQT);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(this.currencyId));
        jSONObject.put((Object)"amountPerUnitNQT", (Object)this.amountPerUnitNQT);
    }

    @Override
    public TransactionType getTransactionType() {
        return MonetarySystemTransactionType.RESERVE_INCREASE;
    }

    @Override
    public long getCurrencyId() {
        return this.currencyId;
    }

    public long getAmountPerUnitNQT() {
        return this.amountPerUnitNQT;
    }
}

