/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.Transaction;
import nxt.peer.NetworkMessage;
import nxt.peer.Peer;
import nxt.peer.PeerImpl;
import nxt.peer.Peers;
import nxt.util.Logger;

public final class TransactionsInventory {
    private static final ConcurrentHashMap<ChainTransactionId, Transaction> transactionCache = new ConcurrentHashMap();
    private static final Set<ChainTransactionId> pendingTransactions = Collections.synchronizedSet(new HashSet());
    private static final ConcurrentHashMap<ChainTransactionId, Transaction> notCurrentlyValidTransactions = new ConcurrentHashMap();

    private TransactionsInventory() {
    }

    static NetworkMessage processRequest(PeerImpl peerImpl, NetworkMessage.TransactionsInventoryMessage transactionsInventoryMessage) {
        List<ChainTransactionId> list = transactionsInventoryMessage.getTransactionIds();
        ArrayList<ChainTransactionId> arrayList = new ArrayList<ChainTransactionId>(Math.min(100, list.size()));
        for (ChainTransactionId chainTransactionId : list) {
            if (transactionCache.get(chainTransactionId) != null || notCurrentlyValidTransactions.get(chainTransactionId) != null || pendingTransactions.contains(chainTransactionId)) continue;
            arrayList.add(chainTransactionId);
            pendingTransactions.add(chainTransactionId);
            if (Peers.isLogLevelEnabled(2)) {
                Logger.logDebugMessage("Requesting transaction " + chainTransactionId.getStringId());
            }
            if (arrayList.size() < 100) continue;
            break;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        Peers.peersService.execute(() -> {
            List<Peer> list2;
            block9: {
                list2 = Peers.getConnectedPeers();
                if (!list2.isEmpty()) break block9;
                arrayList.forEach(pendingTransactions::remove);
                return;
            }
            try {
                Object object;
                int n = list2.indexOf(peerImpl);
                if (n < 0) {
                    n = 0;
                }
                int n2 = n;
                HashSet<Transaction> hashSet = new HashSet<Transaction>();
                do {
                    NetworkMessage.GetTransactionsMessage getTransactionsMessage;
                    NetworkMessage.TransactionsMessage transactionsMessage;
                    if ((transactionsMessage = (NetworkMessage.TransactionsMessage)(object = list2.get(n2)).sendRequest(getTransactionsMessage = new NetworkMessage.GetTransactionsMessage(arrayList))) == null || transactionsMessage.getTransactionCount() <= 0) continue;
                    try {
                        List<Transaction> list3 = transactionsMessage.getTransactions();
                        hashSet.addAll(list3);
                        list3.forEach(transaction -> {
                            ChainTransactionId chainTransactionId = ChainTransactionId.getChainTransactionId(transaction);
                            arrayList.remove(chainTransactionId);
                            pendingTransactions.remove(chainTransactionId);
                            if (Peers.isLogLevelEnabled(2)) {
                                Logger.logDebugMessage("Received transaction " + transaction.getStringId());
                            }
                        });
                        List<? extends Transaction> list4 = Nxt.getTransactionProcessor().processPeerTransactions(list3);
                        TransactionsInventory.cacheTransactions(list4);
                        hashSet.removeAll(list4);
                    }
                    catch (RuntimeException | NxtException.ValidationException exception) {
                        object.blacklist(exception);
                    }
                } while (!arrayList.isEmpty() && (n2 = n2 < list2.size() - 1 ? n2 + 1 : 0) != n);
                try {
                    hashSet.forEach(transaction -> notCurrentlyValidTransactions.put(ChainTransactionId.getChainTransactionId(transaction), (Transaction)transaction));
                    object = Nxt.getTransactionProcessor().processPeerTransactions(new ArrayList<Transaction>(notCurrentlyValidTransactions.values()));
                    object.forEach(transaction -> notCurrentlyValidTransactions.remove(ChainTransactionId.getChainTransactionId(transaction)));
                }
                catch (NxtException.NotValidException notValidException) {
                    Logger.logErrorMessage(notValidException.getMessage(), notValidException);
                }
            }
            catch (Throwable throwable) {
                arrayList.forEach(pendingTransactions::remove);
                throw throwable;
            }
            arrayList.forEach(pendingTransactions::remove);
        });
        return null;
    }

    static Transaction getCachedTransaction(ChainTransactionId chainTransactionId) {
        return transactionCache.get(chainTransactionId);
    }

    public static void cacheTransactions(List<? extends Transaction> list) {
        list.forEach(transaction -> transactionCache.put(ChainTransactionId.getChainTransactionId(transaction), (Transaction)transaction));
    }

    static {
        Nxt.getBlockchainProcessor().addListener(block -> {
            int n = Nxt.getEpochTime();
            transactionCache.values().removeIf(transaction -> n - transaction.getTimestamp() > 600);
            notCurrentlyValidTransactions.values().removeIf(transaction -> n - transaction.getTimestamp() > 600 || transaction.getTimestamp() > n + 15);
        }, BlockchainProcessor.Event.BLOCK_PUSHED);
    }
}

