/*
 * Decompiled with CFR 0.152.
 */
package nxt.shuffling;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.shuffling.ShufflingAttachment;
import nxt.shuffling.ShufflingTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class ShufflingRegistrationAttachment
extends Attachment.AbstractAttachment
implements ShufflingAttachment {
    private final byte[] shufflingFullHash;

    ShufflingRegistrationAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.shufflingFullHash = new byte[32];
        byteBuffer.get(this.shufflingFullHash);
    }

    ShufflingRegistrationAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.shufflingFullHash = Convert.parseHexString((String)jSONObject.get((Object)"shufflingFullHash"));
    }

    public ShufflingRegistrationAttachment(byte[] byArray) {
        this.shufflingFullHash = byArray;
    }

    @Override
    public TransactionType getTransactionType() {
        return ShufflingTransactionType.SHUFFLING_REGISTRATION;
    }

    @Override
    protected int getMySize() {
        return 32;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.put(this.shufflingFullHash);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"shufflingFullHash", (Object)Convert.toHexString(this.shufflingFullHash));
    }

    @Override
    public byte[] getShufflingFullHash() {
        return this.shufflingFullHash;
    }

    @Override
    public byte[] getShufflingStateHash() {
        return this.shufflingFullHash;
    }
}

