/*
 * Decompiled with CFR 0.152.
 */
package nxt.shuffling;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.account.BalanceHome;
import nxt.account.HoldingType;
import nxt.ae.Asset;
import nxt.blockchain.Attachment;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionType;
import nxt.crypto.Crypto;
import nxt.ms.Currency;
import nxt.ms.CurrencyType;
import nxt.ms.MonetarySystemTransactionType;
import nxt.shuffling.ShufflingCancellationAttachment;
import nxt.shuffling.ShufflingCreationAttachment;
import nxt.shuffling.ShufflingHome;
import nxt.shuffling.ShufflingParticipantHome;
import nxt.shuffling.ShufflingProcessingAttachment;
import nxt.shuffling.ShufflingRecipientsAttachment;
import nxt.shuffling.ShufflingRegistrationAttachment;
import nxt.shuffling.ShufflingStage;
import nxt.shuffling.ShufflingVerificationAttachment;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public abstract class ShufflingTransactionType
extends ChildTransactionType {
    private static final byte SUBTYPE_SHUFFLING_CREATION = 0;
    private static final byte SUBTYPE_SHUFFLING_REGISTRATION = 1;
    private static final byte SUBTYPE_SHUFFLING_PROCESSING = 2;
    private static final byte SUBTYPE_SHUFFLING_RECIPIENTS = 3;
    private static final byte SUBTYPE_SHUFFLING_VERIFICATION = 4;
    private static final byte SUBTYPE_SHUFFLING_CANCELLATION = 5;
    private static final Fee SHUFFLING_PROCESSING_FEE = new Fee.ConstantFee(10000000L);
    private static final Fee SHUFFLING_RECIPIENTS_FEE = new Fee.ConstantFee(11000000L);
    public static final TransactionType SHUFFLING_CREATION = new ShufflingTransactionType(){

        @Override
        public byte getSubtype() {
            return 0;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.SHUFFLING_REGISTRATION;
        }

        @Override
        public String getName() {
            return "ShufflingCreation";
        }

        @Override
        public Attachment.AbstractAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new ShufflingCreationAttachment(byteBuffer);
        }

        @Override
        public Attachment.AbstractAttachment parseAttachment(JSONObject jSONObject) {
            return new ShufflingCreationAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            ShufflingCreationAttachment shufflingCreationAttachment = (ShufflingCreationAttachment)childTransactionImpl.getAttachment();
            HoldingType holdingType = shufflingCreationAttachment.getHoldingType();
            long l = shufflingCreationAttachment.getAmount();
            switch (holdingType) {
                case COIN: {
                    if (shufflingCreationAttachment.getHoldingId() != (long)childTransactionImpl.getChain().getId()) {
                        throw new NxtException.NotValidException("Holding id " + Long.toUnsignedString(shufflingCreationAttachment.getHoldingId()) + " does not match chain id " + childTransactionImpl.getChain().getId());
                    }
                    if (l >= childTransactionImpl.getChain().SHUFFLING_DEPOSIT_NQT && l <= 100000000000000000L) break;
                    throw new NxtException.NotValidException("Invalid NQT amount " + l + ", minimum is " + childTransactionImpl.getChain().SHUFFLING_DEPOSIT_NQT);
                }
                case ASSET: {
                    if (l <= 0L || l > 100000000000000000L) {
                        throw new NxtException.NotValidException("Invalid asset quantity " + l);
                    }
                    Asset asset = Asset.getAsset(shufflingCreationAttachment.getHoldingId());
                    if (asset == null) {
                        throw new NxtException.NotCurrentlyValidException("Unknown asset " + Long.toUnsignedString(shufflingCreationAttachment.getHoldingId()));
                    }
                    if (l <= asset.getQuantityQNT()) break;
                    throw new NxtException.NotCurrentlyValidException("Invalid asset quantity " + l);
                }
                case CURRENCY: {
                    Currency currency = Currency.getCurrency(shufflingCreationAttachment.getHoldingId());
                    CurrencyType.validate(currency, (Transaction)childTransactionImpl);
                    if (!currency.isActive()) {
                        throw new NxtException.NotCurrentlyValidException("Currency is not active: " + currency.getCode());
                    }
                    if (l > 0L && l <= 100000000000000000L) break;
                    throw new NxtException.NotValidException("Invalid currency amount " + l);
                }
                default: {
                    throw new RuntimeException("Unsupported holding type " + (Object)((Object)holdingType));
                }
            }
            if (shufflingCreationAttachment.getParticipantCount() < 3 || shufflingCreationAttachment.getParticipantCount() > 30) {
                throw new NxtException.NotValidException(String.format("Number of participants %d is not between %d and %d", shufflingCreationAttachment.getParticipantCount(), (byte)3, (byte)30));
            }
            if (shufflingCreationAttachment.getRegistrationPeriod() < 1 || shufflingCreationAttachment.getRegistrationPeriod() > 10080) {
                throw new NxtException.NotValidException("Invalid registration period: " + shufflingCreationAttachment.getRegistrationPeriod());
            }
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            ShufflingCreationAttachment shufflingCreationAttachment = (ShufflingCreationAttachment)childTransactionImpl.getAttachment();
            HoldingType holdingType = shufflingCreationAttachment.getHoldingType();
            ChildChain childChain = childTransactionImpl.getChain();
            AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(childTransactionImpl);
            BalanceHome.Balance balance = childChain.getBalanceHome().getBalance(account.getId());
            if (holdingType != HoldingType.COIN) {
                if (holdingType.getUnconfirmedBalance(account, shufflingCreationAttachment.getHoldingId()) >= shufflingCreationAttachment.getAmount() && balance.getUnconfirmedBalance() >= childChain.SHUFFLING_DEPOSIT_NQT) {
                    holdingType.addToUnconfirmedBalance(account, this.getLedgerEvent(), ledgerEventId, shufflingCreationAttachment.getHoldingId(), -shufflingCreationAttachment.getAmount());
                    balance.addToUnconfirmedBalance(this.getLedgerEvent(), ledgerEventId, -childChain.SHUFFLING_DEPOSIT_NQT);
                    return true;
                }
            } else if (balance.getUnconfirmedBalance() >= shufflingCreationAttachment.getAmount()) {
                balance.addToUnconfirmedBalance(this.getLedgerEvent(), ledgerEventId, -shufflingCreationAttachment.getAmount());
                return true;
            }
            return false;
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            ShufflingCreationAttachment shufflingCreationAttachment = (ShufflingCreationAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getShufflingHome().addShuffling(childTransactionImpl, shufflingCreationAttachment);
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            ShufflingCreationAttachment shufflingCreationAttachment = (ShufflingCreationAttachment)childTransactionImpl.getAttachment();
            HoldingType holdingType = shufflingCreationAttachment.getHoldingType();
            ChildChain childChain = childTransactionImpl.getChain();
            AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(childTransactionImpl);
            if (holdingType != HoldingType.COIN) {
                holdingType.addToUnconfirmedBalance(account, this.getLedgerEvent(), ledgerEventId, shufflingCreationAttachment.getHoldingId(), shufflingCreationAttachment.getAmount());
                account.addToUnconfirmedBalance(childChain, this.getLedgerEvent(), ledgerEventId, childChain.SHUFFLING_DEPOSIT_NQT);
            } else {
                account.addToUnconfirmedBalance(childChain, this.getLedgerEvent(), ledgerEventId, shufflingCreationAttachment.getAmount());
            }
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            ShufflingCreationAttachment shufflingCreationAttachment = (ShufflingCreationAttachment)transaction.getAttachment();
            if (shufflingCreationAttachment.getHoldingType() != HoldingType.CURRENCY) {
                return false;
            }
            Currency currency = Currency.getCurrency(shufflingCreationAttachment.getHoldingId());
            String string = currency.getName().toLowerCase(Locale.ROOT);
            String string2 = currency.getCode().toLowerCase(Locale.ROOT);
            boolean bl = TransactionType.isDuplicate(MonetarySystemTransactionType.CURRENCY_ISSUANCE, string, map, false);
            if (!string.equals(string2)) {
                bl = bl || TransactionType.isDuplicate(MonetarySystemTransactionType.CURRENCY_ISSUANCE, string2, map, false);
            }
            return bl;
        }
    };
    public static final TransactionType SHUFFLING_REGISTRATION = new ShufflingTransactionType(){

        @Override
        public byte getSubtype() {
            return 1;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.SHUFFLING_REGISTRATION;
        }

        @Override
        public String getName() {
            return "ShufflingRegistration";
        }

        @Override
        public Attachment.AbstractAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new ShufflingRegistrationAttachment(byteBuffer);
        }

        @Override
        public Attachment.AbstractAttachment parseAttachment(JSONObject jSONObject) {
            return new ShufflingRegistrationAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            ShufflingRegistrationAttachment shufflingRegistrationAttachment = (ShufflingRegistrationAttachment)childTransactionImpl.getAttachment();
            ShufflingHome.Shuffling shuffling = childTransactionImpl.getChain().getShufflingHome().getShuffling(shufflingRegistrationAttachment.getShufflingFullHash());
            if (shuffling == null) {
                throw new NxtException.NotCurrentlyValidException("Shuffling not found: " + Convert.toHexString(shufflingRegistrationAttachment.getShufflingFullHash()));
            }
            byte[] byArray = shuffling.getStateHash();
            if (byArray == null || !Arrays.equals(byArray, shufflingRegistrationAttachment.getShufflingStateHash())) {
                throw new NxtException.NotCurrentlyValidException("Shuffling state hash doesn't match");
            }
            if (shuffling.getStage() != ShufflingStage.REGISTRATION) {
                throw new NxtException.NotCurrentlyValidException("Shuffling registration has ended for " + Convert.toHexString(shufflingRegistrationAttachment.getShufflingFullHash()));
            }
            if (shuffling.getParticipant(childTransactionImpl.getSenderId()) != null) {
                throw new NxtException.NotCurrentlyValidException(String.format("Account %s is already registered for shuffling %s", Long.toUnsignedString(childTransactionImpl.getSenderId()), Long.toUnsignedString(shuffling.getId())));
            }
            if (Nxt.getBlockchain().getHeight() + shuffling.getBlocksRemaining() <= shufflingRegistrationAttachment.getFinishValidationHeight(childTransactionImpl)) {
                throw new NxtException.NotCurrentlyValidException("Shuffling registration finishes in " + shuffling.getBlocksRemaining() + " blocks");
            }
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            ShufflingRegistrationAttachment shufflingRegistrationAttachment = (ShufflingRegistrationAttachment)transaction.getAttachment();
            ShufflingHome.Shuffling shuffling = ((ChildChain)transaction.getChain()).getShufflingHome().getShuffling(shufflingRegistrationAttachment.getShufflingFullHash());
            return TransactionType.isDuplicate(SHUFFLING_REGISTRATION, Long.toUnsignedString(shuffling.getId()) + "." + Long.toUnsignedString(transaction.getSenderId()), map, true) || TransactionType.isDuplicate(SHUFFLING_REGISTRATION, Long.toUnsignedString(shuffling.getId()), map, shuffling.getParticipantCount() - shuffling.getRegistrantCount());
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            ShufflingRegistrationAttachment shufflingRegistrationAttachment = (ShufflingRegistrationAttachment)childTransactionImpl.getAttachment();
            ChildChain childChain = childTransactionImpl.getChain();
            ShufflingHome.Shuffling shuffling = childChain.getShufflingHome().getShuffling(shufflingRegistrationAttachment.getShufflingFullHash());
            HoldingType holdingType = shuffling.getHoldingType();
            AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(childTransactionImpl);
            BalanceHome.Balance balance = childChain.getBalanceHome().getBalance(account.getId());
            if (holdingType != HoldingType.COIN) {
                if (holdingType.getUnconfirmedBalance(account, shuffling.getHoldingId()) >= shuffling.getAmount() && balance.getUnconfirmedBalance() >= childChain.SHUFFLING_DEPOSIT_NQT) {
                    holdingType.addToUnconfirmedBalance(account, this.getLedgerEvent(), ledgerEventId, shuffling.getHoldingId(), -shuffling.getAmount());
                    balance.addToUnconfirmedBalance(this.getLedgerEvent(), ledgerEventId, -childChain.SHUFFLING_DEPOSIT_NQT);
                    return true;
                }
            } else if (balance.getUnconfirmedBalance() >= shuffling.getAmount()) {
                balance.addToUnconfirmedBalance(this.getLedgerEvent(), ledgerEventId, -shuffling.getAmount());
                return true;
            }
            return false;
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            ShufflingRegistrationAttachment shufflingRegistrationAttachment = (ShufflingRegistrationAttachment)childTransactionImpl.getAttachment();
            ShufflingHome.Shuffling shuffling = childTransactionImpl.getChain().getShufflingHome().getShuffling(shufflingRegistrationAttachment.getShufflingFullHash());
            shuffling.addParticipant(childTransactionImpl.getSenderId());
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            ShufflingRegistrationAttachment shufflingRegistrationAttachment = (ShufflingRegistrationAttachment)childTransactionImpl.getAttachment();
            ChildChain childChain = childTransactionImpl.getChain();
            ShufflingHome.Shuffling shuffling = childChain.getShufflingHome().getShuffling(shufflingRegistrationAttachment.getShufflingFullHash());
            HoldingType holdingType = shuffling.getHoldingType();
            AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(childTransactionImpl);
            if (holdingType != HoldingType.COIN) {
                holdingType.addToUnconfirmedBalance(account, this.getLedgerEvent(), ledgerEventId, shuffling.getHoldingId(), shuffling.getAmount());
                account.addToUnconfirmedBalance(childChain, this.getLedgerEvent(), ledgerEventId, childChain.SHUFFLING_DEPOSIT_NQT);
            } else {
                account.addToUnconfirmedBalance(childChain, this.getLedgerEvent(), ledgerEventId, shuffling.getAmount());
            }
        }
    };
    public static final TransactionType SHUFFLING_PROCESSING = new ShufflingTransactionType(){

        @Override
        public byte getSubtype() {
            return 2;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.SHUFFLING_PROCESSING;
        }

        @Override
        public String getName() {
            return "ShufflingProcessing";
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return SHUFFLING_PROCESSING_FEE;
        }

        @Override
        public Attachment.AbstractAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new ShufflingProcessingAttachment(byteBuffer);
        }

        @Override
        public Attachment.AbstractAttachment parseAttachment(JSONObject jSONObject) {
            return new ShufflingProcessingAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            ShufflingProcessingAttachment shufflingProcessingAttachment = (ShufflingProcessingAttachment)childTransactionImpl.getAttachment();
            ShufflingHome.Shuffling shuffling = childTransactionImpl.getChain().getShufflingHome().getShuffling(shufflingProcessingAttachment.getShufflingFullHash());
            if (shuffling == null) {
                throw new NxtException.NotCurrentlyValidException("Shuffling not found: " + Convert.toHexString(shufflingProcessingAttachment.getShufflingFullHash()));
            }
            if (shuffling.getStage() != ShufflingStage.PROCESSING) {
                throw new NxtException.NotCurrentlyValidException(String.format("Shuffling %s is not in processing stage", Convert.toHexString(shufflingProcessingAttachment.getShufflingFullHash())));
            }
            ShufflingParticipantHome.ShufflingParticipant shufflingParticipant = shuffling.getParticipant(childTransactionImpl.getSenderId());
            if (shufflingParticipant == null) {
                throw new NxtException.NotCurrentlyValidException(String.format("Account %s is not registered for shuffling %s", Long.toUnsignedString(childTransactionImpl.getSenderId()), Long.toUnsignedString(shuffling.getId())));
            }
            if (!shufflingParticipant.getState().canBecome(ShufflingParticipantHome.State.PROCESSED)) {
                throw new NxtException.NotCurrentlyValidException(String.format("Participant %s processing already complete", Long.toUnsignedString(childTransactionImpl.getSenderId())));
            }
            if (shufflingParticipant.getAccountId() != shuffling.getAssigneeAccountId()) {
                throw new NxtException.NotCurrentlyValidException(String.format("Participant %s is not currently assigned to process shuffling %s", Long.toUnsignedString(shufflingParticipant.getAccountId()), Long.toUnsignedString(shuffling.getId())));
            }
            if (shufflingParticipant.getNextAccountId() == 0L) {
                throw new NxtException.NotValidException(String.format("Participant %s is last in shuffle", Long.toUnsignedString(childTransactionImpl.getSenderId())));
            }
            byte[] byArray = shuffling.getStateHash();
            if (byArray == null || !Arrays.equals(byArray, shufflingProcessingAttachment.getShufflingStateHash())) {
                throw new NxtException.NotCurrentlyValidException("Shuffling state hash doesn't match");
            }
            byte[][] byArray2 = shufflingProcessingAttachment.getData();
            if (byArray2 == null && Nxt.getEpochTime() - childTransactionImpl.getTimestamp() < Constants.MIN_PRUNABLE_LIFETIME) {
                throw new NxtException.NotCurrentlyValidException("Data has been pruned prematurely");
            }
            if (byArray2 != null) {
                if (byArray2.length != shufflingParticipant.getIndex() + 1 && byArray2.length != 0) {
                    throw new NxtException.NotValidException(String.format("Invalid number of encrypted data %d for participant number %d", byArray2.length, shufflingParticipant.getIndex()));
                }
                byte[] byArray3 = null;
                for (byte[] byArray4 : byArray2) {
                    if (byArray4.length != 32 + 64 * (shuffling.getParticipantCount() - shufflingParticipant.getIndex() - 1)) {
                        throw new NxtException.NotValidException("Invalid encrypted data length " + byArray4.length);
                    }
                    if (byArray3 != null && Convert.byteArrayComparator.compare(byArray3, byArray4) >= 0) {
                        throw new NxtException.NotValidException("Duplicate or unsorted encrypted data");
                    }
                    byArray3 = byArray4;
                }
            }
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            ShufflingProcessingAttachment shufflingProcessingAttachment = (ShufflingProcessingAttachment)transaction.getAttachment();
            ShufflingHome.Shuffling shuffling = ((ChildChain)transaction.getChain()).getShufflingHome().getShuffling(shufflingProcessingAttachment.getShufflingFullHash());
            return TransactionType.isDuplicate(SHUFFLING_PROCESSING, Long.toUnsignedString(shuffling.getId()), map, true);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            return true;
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            ShufflingProcessingAttachment shufflingProcessingAttachment = (ShufflingProcessingAttachment)childTransactionImpl.getAttachment();
            ShufflingHome.Shuffling shuffling = childTransactionImpl.getChain().getShufflingHome().getShuffling(shufflingProcessingAttachment.getShufflingFullHash());
            shuffling.updateParticipantData(childTransactionImpl, shufflingProcessingAttachment);
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        }

        @Override
        public boolean isPhasable() {
            return false;
        }

        @Override
        public boolean isPruned(Chain chain, byte[] byArray) {
            TransactionImpl transactionImpl = chain.getTransactionHome().findTransaction(byArray);
            ShufflingProcessingAttachment shufflingProcessingAttachment = (ShufflingProcessingAttachment)transactionImpl.getAttachment();
            return ((ChildChain)chain).getShufflingParticipantHome().getData(shufflingProcessingAttachment.getShufflingFullHash(), transactionImpl.getSenderId()) == null;
        }
    };
    public static final TransactionType SHUFFLING_RECIPIENTS = new ShufflingTransactionType(){

        @Override
        public byte getSubtype() {
            return 3;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.SHUFFLING_PROCESSING;
        }

        @Override
        public String getName() {
            return "ShufflingRecipients";
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return SHUFFLING_RECIPIENTS_FEE;
        }

        @Override
        public Attachment.AbstractAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new ShufflingRecipientsAttachment(byteBuffer);
        }

        @Override
        public Attachment.AbstractAttachment parseAttachment(JSONObject jSONObject) {
            return new ShufflingRecipientsAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            ShufflingRecipientsAttachment shufflingRecipientsAttachment = (ShufflingRecipientsAttachment)childTransactionImpl.getAttachment();
            ShufflingHome.Shuffling shuffling = childTransactionImpl.getChain().getShufflingHome().getShuffling(shufflingRecipientsAttachment.getShufflingFullHash());
            if (shuffling == null) {
                throw new NxtException.NotCurrentlyValidException("Shuffling not found: " + Convert.toHexString(shufflingRecipientsAttachment.getShufflingFullHash()));
            }
            if (shuffling.getStage() != ShufflingStage.PROCESSING) {
                throw new NxtException.NotCurrentlyValidException(String.format("Shuffling %s is not in processing stage", Convert.toHexString(shufflingRecipientsAttachment.getShufflingFullHash())));
            }
            ShufflingParticipantHome.ShufflingParticipant shufflingParticipant = shuffling.getParticipant(childTransactionImpl.getSenderId());
            if (shufflingParticipant == null) {
                throw new NxtException.NotCurrentlyValidException(String.format("Account %s is not registered for shuffling %s", Long.toUnsignedString(childTransactionImpl.getSenderId()), Long.toUnsignedString(shuffling.getId())));
            }
            if (shufflingParticipant.getNextAccountId() != 0L) {
                throw new NxtException.NotValidException(String.format("Participant %s is not last in shuffle", Long.toUnsignedString(childTransactionImpl.getSenderId())));
            }
            if (!shufflingParticipant.getState().canBecome(ShufflingParticipantHome.State.PROCESSED)) {
                throw new NxtException.NotCurrentlyValidException(String.format("Participant %s processing already complete", Long.toUnsignedString(childTransactionImpl.getSenderId())));
            }
            if (shufflingParticipant.getAccountId() != shuffling.getAssigneeAccountId()) {
                throw new NxtException.NotCurrentlyValidException(String.format("Participant %s is not currently assigned to process shuffling %s", Long.toUnsignedString(shufflingParticipant.getAccountId()), Long.toUnsignedString(shuffling.getId())));
            }
            byte[] byArray = shuffling.getStateHash();
            if (byArray == null || !Arrays.equals(byArray, shufflingRecipientsAttachment.getShufflingStateHash())) {
                throw new NxtException.NotCurrentlyValidException("Shuffling state hash doesn't match");
            }
            byte[][] byArray2 = shufflingRecipientsAttachment.getRecipientPublicKeys();
            if (byArray2.length != shuffling.getParticipantCount() && byArray2.length != 0) {
                throw new NxtException.NotValidException(String.format("Invalid number of recipient public keys %d", byArray2.length));
            }
            HashSet<Long> hashSet = new HashSet<Long>(byArray2.length);
            for (byte[] byArray3 : byArray2) {
                if (!Crypto.isCanonicalPublicKey(byArray3)) {
                    throw new NxtException.NotValidException("Invalid recipient public key " + Convert.toHexString(byArray3));
                }
                if (hashSet.add(Account.getId(byArray3))) continue;
                throw new NxtException.NotValidException("Duplicate recipient accounts");
            }
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            ShufflingRecipientsAttachment shufflingRecipientsAttachment = (ShufflingRecipientsAttachment)transaction.getAttachment();
            ShufflingHome.Shuffling shuffling = ((ChildChain)transaction.getChain()).getShufflingHome().getShuffling(shufflingRecipientsAttachment.getShufflingFullHash());
            return TransactionType.isDuplicate(SHUFFLING_PROCESSING, Long.toUnsignedString(shuffling.getId()), map, true);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            return true;
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            ShufflingRecipientsAttachment shufflingRecipientsAttachment = (ShufflingRecipientsAttachment)childTransactionImpl.getAttachment();
            ShufflingHome.Shuffling shuffling = childTransactionImpl.getChain().getShufflingHome().getShuffling(shufflingRecipientsAttachment.getShufflingFullHash());
            shuffling.updateRecipients(childTransactionImpl, shufflingRecipientsAttachment);
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        }

        @Override
        public boolean isPhasable() {
            return false;
        }
    };
    public static final TransactionType SHUFFLING_VERIFICATION = new ShufflingTransactionType(){

        @Override
        public byte getSubtype() {
            return 4;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.SHUFFLING_PROCESSING;
        }

        @Override
        public String getName() {
            return "ShufflingVerification";
        }

        @Override
        public Attachment.AbstractAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new ShufflingVerificationAttachment(byteBuffer);
        }

        @Override
        public Attachment.AbstractAttachment parseAttachment(JSONObject jSONObject) {
            return new ShufflingVerificationAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            ShufflingVerificationAttachment shufflingVerificationAttachment = (ShufflingVerificationAttachment)childTransactionImpl.getAttachment();
            ShufflingHome.Shuffling shuffling = childTransactionImpl.getChain().getShufflingHome().getShuffling(shufflingVerificationAttachment.getShufflingFullHash());
            if (shuffling == null) {
                throw new NxtException.NotCurrentlyValidException("Shuffling not found: " + Convert.toHexString(shufflingVerificationAttachment.getShufflingFullHash()));
            }
            if (shuffling.getStage() != ShufflingStage.VERIFICATION) {
                throw new NxtException.NotCurrentlyValidException("Shuffling not in verification stage: " + Convert.toHexString(shufflingVerificationAttachment.getShufflingFullHash()));
            }
            ShufflingParticipantHome.ShufflingParticipant shufflingParticipant = shuffling.getParticipant(childTransactionImpl.getSenderId());
            if (shufflingParticipant == null) {
                throw new NxtException.NotCurrentlyValidException(String.format("Account %s is not registered for shuffling %s", Long.toUnsignedString(childTransactionImpl.getSenderId()), Long.toUnsignedString(shuffling.getId())));
            }
            if (!shufflingParticipant.getState().canBecome(ShufflingParticipantHome.State.VERIFIED)) {
                throw new NxtException.NotCurrentlyValidException(String.format("Shuffling participant %s in state %s cannot become verified", new Object[]{Convert.toHexString(shufflingVerificationAttachment.getShufflingFullHash()), shufflingParticipant.getState()}));
            }
            if (shufflingParticipant.getIndex() == shuffling.getParticipantCount() - 1) {
                throw new NxtException.NotValidException("Last participant cannot submit verification transaction");
            }
            byte[] byArray = shuffling.getStateHash();
            if (byArray == null || !Arrays.equals(byArray, shufflingVerificationAttachment.getShufflingStateHash())) {
                throw new NxtException.NotCurrentlyValidException("Shuffling state hash doesn't match");
            }
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            ShufflingVerificationAttachment shufflingVerificationAttachment = (ShufflingVerificationAttachment)transaction.getAttachment();
            ShufflingHome.Shuffling shuffling = ((ChildChain)transaction.getChain()).getShufflingHome().getShuffling(shufflingVerificationAttachment.getShufflingFullHash());
            return TransactionType.isDuplicate(SHUFFLING_VERIFICATION, Long.toUnsignedString(shuffling.getId()) + "." + Long.toUnsignedString(transaction.getSenderId()), map, true);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            return true;
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            ShufflingVerificationAttachment shufflingVerificationAttachment = (ShufflingVerificationAttachment)childTransactionImpl.getAttachment();
            ShufflingHome.Shuffling shuffling = childTransactionImpl.getChain().getShufflingHome().getShuffling(shufflingVerificationAttachment.getShufflingFullHash());
            shuffling.verify(childTransactionImpl.getSenderId());
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        }

        @Override
        public boolean isPhasable() {
            return false;
        }
    };
    public static final TransactionType SHUFFLING_CANCELLATION = new ShufflingTransactionType(){

        @Override
        public byte getSubtype() {
            return 5;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.SHUFFLING_PROCESSING;
        }

        @Override
        public String getName() {
            return "ShufflingCancellation";
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return SHUFFLING_PROCESSING_FEE;
        }

        @Override
        public Attachment.AbstractAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new ShufflingCancellationAttachment(byteBuffer);
        }

        @Override
        public Attachment.AbstractAttachment parseAttachment(JSONObject jSONObject) {
            return new ShufflingCancellationAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            ShufflingCancellationAttachment shufflingCancellationAttachment = (ShufflingCancellationAttachment)childTransactionImpl.getAttachment();
            ShufflingHome.Shuffling shuffling = childTransactionImpl.getChain().getShufflingHome().getShuffling(shufflingCancellationAttachment.getShufflingFullHash());
            if (shuffling == null) {
                throw new NxtException.NotCurrentlyValidException("Shuffling not found: " + Convert.toHexString(shufflingCancellationAttachment.getShufflingFullHash()));
            }
            long l = shufflingCancellationAttachment.getCancellingAccountId();
            if (l == 0L && !shuffling.getStage().canBecome(ShufflingStage.BLAME)) {
                throw new NxtException.NotCurrentlyValidException(String.format("Shuffling in state %s cannot be cancelled", new Object[]{shuffling.getStage()}));
            }
            if (l != 0L && l != shuffling.getAssigneeAccountId()) {
                throw new NxtException.NotCurrentlyValidException(String.format("Shuffling %s is not currently being cancelled by account %s", Long.toUnsignedString(shuffling.getId()), Long.toUnsignedString(l)));
            }
            ShufflingParticipantHome.ShufflingParticipant shufflingParticipant = shuffling.getParticipant(childTransactionImpl.getSenderId());
            if (shufflingParticipant == null) {
                throw new NxtException.NotCurrentlyValidException(String.format("Account %s is not registered for shuffling %s", Long.toUnsignedString(childTransactionImpl.getSenderId()), Long.toUnsignedString(shuffling.getId())));
            }
            if (!shufflingParticipant.getState().canBecome(ShufflingParticipantHome.State.CANCELLED)) {
                throw new NxtException.NotCurrentlyValidException(String.format("Shuffling participant %s in state %s cannot submit cancellation", new Object[]{Convert.toHexString(shufflingCancellationAttachment.getShufflingFullHash()), shufflingParticipant.getState()}));
            }
            if (shufflingParticipant.getIndex() == shuffling.getParticipantCount() - 1) {
                throw new NxtException.NotValidException("Last participant cannot submit cancellation transaction");
            }
            byte[] byArray = shuffling.getStateHash();
            if (byArray == null || !Arrays.equals(byArray, shufflingCancellationAttachment.getShufflingStateHash())) {
                throw new NxtException.NotCurrentlyValidException("Shuffling state hash doesn't match");
            }
            TransactionImpl transactionImpl = childTransactionImpl.getChain().getTransactionHome().findTransaction(shufflingParticipant.getDataTransactionFullHash(), Nxt.getBlockchain().getHeight());
            if (transactionImpl == null) {
                throw new NxtException.NotCurrentlyValidException("Invalid data transaction full hash");
            }
            ShufflingProcessingAttachment shufflingProcessingAttachment = (ShufflingProcessingAttachment)transactionImpl.getAttachment();
            if (!Arrays.equals(shufflingProcessingAttachment.getHash(), shufflingCancellationAttachment.getHash())) {
                throw new NxtException.NotValidException("Blame data hash doesn't match processing data hash");
            }
            byte[][] byArray2 = shufflingCancellationAttachment.getKeySeeds();
            if (byArray2.length != shuffling.getParticipantCount() - shufflingParticipant.getIndex() - 1) {
                throw new NxtException.NotValidException("Invalid number of revealed keySeeds: " + byArray2.length);
            }
            for (byte[] byArray3 : byArray2) {
                if (byArray3.length == 32) continue;
                throw new NxtException.NotValidException("Invalid keySeed: " + Convert.toHexString(byArray3));
            }
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            ShufflingCancellationAttachment shufflingCancellationAttachment = (ShufflingCancellationAttachment)transaction.getAttachment();
            ShufflingHome.Shuffling shuffling = ((ChildChain)transaction.getChain()).getShufflingHome().getShuffling(shufflingCancellationAttachment.getShufflingFullHash());
            return TransactionType.isDuplicate(SHUFFLING_VERIFICATION, Long.toUnsignedString(shuffling.getId()) + "." + Long.toUnsignedString(transaction.getSenderId()), map, true);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            return true;
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            ShufflingCancellationAttachment shufflingCancellationAttachment = (ShufflingCancellationAttachment)childTransactionImpl.getAttachment();
            ShufflingHome.Shuffling shuffling = childTransactionImpl.getChain().getShufflingHome().getShuffling(shufflingCancellationAttachment.getShufflingFullHash());
            ShufflingParticipantHome.ShufflingParticipant shufflingParticipant = childTransactionImpl.getChain().getShufflingParticipantHome().getParticipant(shuffling.getFullHash(), account.getId());
            shuffling.cancelBy(shufflingParticipant, shufflingCancellationAttachment.getBlameData(), shufflingCancellationAttachment.getKeySeeds());
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        }

        @Override
        public boolean isPhasable() {
            return false;
        }
    };

    public static TransactionType findTransactionType(byte by) {
        switch (by) {
            case 0: {
                return SHUFFLING_CREATION;
            }
            case 1: {
                return SHUFFLING_REGISTRATION;
            }
            case 2: {
                return SHUFFLING_PROCESSING;
            }
            case 3: {
                return SHUFFLING_RECIPIENTS;
            }
            case 4: {
                return SHUFFLING_VERIFICATION;
            }
            case 5: {
                return SHUFFLING_CANCELLATION;
            }
        }
        return null;
    }

    private ShufflingTransactionType() {
    }

    @Override
    public final byte getType() {
        return 7;
    }

    @Override
    public final boolean canHaveRecipient() {
        return false;
    }

    @Override
    public final boolean isPhasingSafe() {
        return false;
    }

    @Override
    public final boolean isGlobal() {
        return false;
    }

    @Override
    public Fee getBaselineFee(Transaction transaction) {
        return new Fee.ConstantFee(1000000L);
    }
}

