/*
 * Decompiled with CFR 0.152.
 */
package nxt.taggeddata;

import java.nio.ByteBuffer;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.blockchain.Appendix;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionType;
import nxt.taggeddata.TaggedDataAttachment;
import org.json.simple.JSONObject;

public abstract class TaggedDataTransactionType
extends ChildTransactionType {
    public static final byte SUBTYPE_DATA_TAGGED_DATA_UPLOAD = 0;
    private static final Fee TAGGED_DATA_FEE = new Fee.SizeBasedFee(10000000L, 1000000L){

        @Override
        public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
            return appendix.getFullSize();
        }
    };
    public static final TransactionType TAGGED_DATA_UPLOAD = new TaggedDataTransactionType(){

        @Override
        public byte getSubtype() {
            return 0;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.TAGGED_DATA_UPLOAD;
        }

        @Override
        public TaggedDataAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new TaggedDataAttachment(byteBuffer);
        }

        @Override
        public TaggedDataAttachment parseAttachment(JSONObject jSONObject) {
            return new TaggedDataAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            TaggedDataAttachment taggedDataAttachment = (TaggedDataAttachment)childTransactionImpl.getAttachment();
            if (taggedDataAttachment.getData() == null && Nxt.getEpochTime() - childTransactionImpl.getTimestamp() < Constants.MIN_PRUNABLE_LIFETIME) {
                throw new NxtException.NotCurrentlyValidException("Data has been pruned prematurely");
            }
            if (taggedDataAttachment.getData() != null) {
                if (taggedDataAttachment.getName().length() == 0 || taggedDataAttachment.getName().length() > 100) {
                    throw new NxtException.NotValidException("Invalid name length: " + taggedDataAttachment.getName().length());
                }
                if (taggedDataAttachment.getDescription().length() > 1000) {
                    throw new NxtException.NotValidException("Invalid description length: " + taggedDataAttachment.getDescription().length());
                }
                if (taggedDataAttachment.getTags().length() > 100) {
                    throw new NxtException.NotValidException("Invalid tags length: " + taggedDataAttachment.getTags().length());
                }
                if (taggedDataAttachment.getType().length() > 100) {
                    throw new NxtException.NotValidException("Invalid type length: " + taggedDataAttachment.getType().length());
                }
                if (taggedDataAttachment.getChannel().length() > 100) {
                    throw new NxtException.NotValidException("Invalid channel length: " + taggedDataAttachment.getChannel().length());
                }
                if (taggedDataAttachment.getFilename().length() > 100) {
                    throw new NxtException.NotValidException("Invalid filename length: " + taggedDataAttachment.getFilename().length());
                }
                if (taggedDataAttachment.getData().length == 0 || taggedDataAttachment.getData().length > 43008) {
                    throw new NxtException.NotValidException("Invalid data length: " + taggedDataAttachment.getData().length);
                }
            }
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            TaggedDataAttachment taggedDataAttachment = (TaggedDataAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getTaggedDataHome().add(childTransactionImpl, taggedDataAttachment);
        }

        @Override
        public String getName() {
            return "TaggedDataUpload";
        }

        @Override
        public boolean isPruned(Chain chain, byte[] byArray) {
            return ((ChildChain)chain).getTaggedDataHome().isPruned(byArray);
        }
    };

    public static TransactionType findTransactionType(byte by) {
        switch (by) {
            case 0: {
                return TAGGED_DATA_UPLOAD;
            }
        }
        return null;
    }

    private TaggedDataTransactionType() {
    }

    @Override
    public final byte getType() {
        return 6;
    }

    @Override
    public final Fee getBaselineFee(Transaction transaction) {
        return TAGGED_DATA_FEE;
    }

    @Override
    public final boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        return true;
    }

    @Override
    public final void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
    }

    @Override
    public final boolean canHaveRecipient() {
        return false;
    }

    @Override
    public final boolean isPhasingSafe() {
        return false;
    }

    @Override
    public final boolean isPhasable() {
        return false;
    }

    @Override
    public final boolean isGlobal() {
        return false;
    }
}

