/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import nxt.util.security.BlockchainPermission;

public final class CompareTraceFiles {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("tools"));
        }
        String string = stringArray.length > 0 ? stringArray[0] : "nxt-trace.csv";
        String string2 = stringArray.length > 1 ? stringArray[1] : "nxt-trace-default.csv";
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
             BufferedReader bufferedReader2 = new BufferedReader(new FileReader(string));){
            String string3;
            System.out.println(bufferedReader.readLine());
            bufferedReader2.readLine();
            String string4 = bufferedReader2.readLine();
            if (string4 == null) {
                System.out.println("Empty trace file, nothing to compare");
                return;
            }
            int n = CompareTraceFiles.parseHeight(string4);
            while ((string3 = bufferedReader.readLine()) != null && CompareTraceFiles.parseHeight(string3) < n) {
            }
            if (string3 == null) {
                System.out.println("End of default trace file, can't compare further");
                return;
            }
            int n2 = n;
            CompareTraceFiles.assertEquals(string3, string4);
            while ((string4 = bufferedReader2.readLine()) != null) {
                string3 = bufferedReader.readLine();
                if (string3 == null) {
                    System.out.println("End of default trace file, can't compare further");
                    return;
                }
                n2 = CompareTraceFiles.parseHeight(string4);
                CompareTraceFiles.assertEquals(string3, string4);
            }
            string3 = bufferedReader.readLine();
            if (string3 != null && CompareTraceFiles.parseHeight(string3) <= n2) {
                System.out.println("default height: " + CompareTraceFiles.parseHeight(string3) + " end height: " + n2);
            }
            System.out.println("Comparison with default trace file done from height " + n + " to " + n2);
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString(), iOException);
        }
    }

    private static int parseHeight(String string) {
        return Integer.parseInt(string.substring(1, string.indexOf(9) - 1));
    }

    private static void assertEquals(String string, String string2) {
        if (!string.equals(string2)) {
            System.out.println("Lines don't match:");
            System.out.println("default:\n" + string);
            System.out.println("test:\n" + string2);
        }
    }
}

