/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.List;
import nxt.NxtException;
import nxt.addons.JO;
import nxt.blockchain.Attachment;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.TransactionImpl;
import nxt.crypto.Crypto;
import nxt.http.APICall;
import nxt.http.callers.BroadcastTransactionCall;
import nxt.http.callers.CalculateFeeCall;
import nxt.http.callers.GetBundlerRatesCall;
import nxt.http.callers.GetECBlockCall;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.security.BlockchainPermission;
import org.json.simple.JSONAware;

public class LocalSigner {
    public static JO signAndBroadcast(ChildChain childChain, long l, Attachment attachment, String string, long l2, long l3, long l4, ChainTransactionId chainTransactionId, URL uRL) {
        APICall.Builder builder;
        TransactionImpl transactionImpl;
        TransactionImpl.BuilderImpl builderImpl;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("tools"));
        }
        GetECBlockCall getECBlockCall = (GetECBlockCall)GetECBlockCall.create().remote(uRL);
        JO jO2 = getECBlockCall.call();
        if (l2 == -1L) {
            builderImpl = childChain.newTransactionBuilder(Crypto.getPublicKey(string), 0L, -1L, (short)15, attachment).timestamp(((Long)jO2.get("timestamp")).intValue()).ecBlockHeight(((Long)jO2.get("ecBlockHeight")).intValue()).ecBlockId(Convert.parseUnsignedLong((String)jO2.get("ecBlockId"))).recipientId(l);
            ((ChildTransactionImpl.BuilderImpl)builderImpl).referencedTransaction(chainTransactionId);
            try {
                transactionImpl = builderImpl.build(string);
            }
            catch (NxtException.NotValidException notValidException) {
                throw new IllegalStateException(notValidException);
            }
            builder = (CalculateFeeCall)CalculateFeeCall.create().transactionJSON(JSON.toJSONString((JSONAware)transactionImpl.getJSONObject())).remote(uRL);
            long l5 = builder.call().getLong("minimumFeeFQT");
            if (l3 == -1L) {
                List<JO> list = ((GetBundlerRatesCall)GetBundlerRatesCall.create().minBundlerBalanceFXT(l4).remote(uRL)).call().getArray("rates").objects();
                Long l6 = list.stream().filter(jO -> jO.getInt("chain") == childChain.getId()).filter(jO -> jO.getLong("currentFeeLimitFQT") > l5).map(jO -> jO.getLong("minRateNQTPerFXT")).sorted().findFirst().orElse(null);
                if (l6 == null) {
                    throw new IllegalStateException("Fee not specified and best bundling fee cannot be determined");
                }
                l3 = l6;
            }
            l2 = BigDecimal.valueOf(l5).multiply(BigDecimal.valueOf(l3)).divide(BigDecimal.valueOf(childChain.ONE_COIN), RoundingMode.HALF_EVEN).longValue();
        }
        builderImpl = childChain.newTransactionBuilder(Crypto.getPublicKey(string), 0L, l2, (short)15, attachment).timestamp(((Long)jO2.get("timestamp")).intValue()).ecBlockHeight(((Long)jO2.get("ecBlockHeight")).intValue()).ecBlockId(Convert.parseUnsignedLong((String)jO2.get("ecBlockId")));
        if (attachment.getTransactionType().canHaveRecipient()) {
            builderImpl.recipientId(l);
        }
        ((ChildTransactionImpl.BuilderImpl)builderImpl).referencedTransaction(chainTransactionId);
        try {
            transactionImpl = builderImpl.build(string);
        }
        catch (NxtException.NotValidException notValidException) {
            throw new IllegalStateException(notValidException);
        }
        builder = (BroadcastTransactionCall)BroadcastTransactionCall.create().transactionBytes(transactionImpl.getBytes()).remote(uRL);
        if (transactionImpl.getPrunableAttachmentJSON() != null) {
            builder = ((BroadcastTransactionCall)builder).prunableAttachmentJSON(transactionImpl.getPrunableAttachmentJSON().toJSONString());
        }
        return builder.call();
    }
}

