/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Console;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import nxt.Nxt;
import nxt.blockchain.Transaction;
import nxt.util.Convert;
import nxt.util.security.BlockchainPermission;

public final class SignTransactions {
    public static void main(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("tools"));
        }
        try {
            String string;
            Object object;
            Console console;
            File file;
            File file2;
            if (stringArray.length != 2) {
                System.out.println("Usage: SignTransactions <unsigned transaction bytes file> <signed transaction bytes file>");
                System.exit(1);
            }
            if (!(file2 = new File(stringArray[0])).exists()) {
                System.out.println("File not found: " + file2.getAbsolutePath());
                System.exit(1);
            }
            if ((file = new File(stringArray[1])).exists()) {
                System.out.println("File already exists: " + file.getAbsolutePath());
                System.exit(1);
            }
            if ((console = System.console()) == null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                object = null;
                try {
                    string = bufferedReader.readLine();
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (bufferedReader != null) {
                        if (object != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            bufferedReader.close();
                        }
                    }
                }
            } else {
                string = new String(console.readPassword("Secret phrase: ", new Object[0]));
            }
            int n = 0;
            object = new BufferedReader(new FileReader(file2));
            Throwable throwable = null;
            try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
                String string2;
                while ((string2 = ((BufferedReader)object).readLine()) != null) {
                    byte[] byArray = Convert.parseHexString(string2);
                    Transaction.Builder builder = Nxt.newTransactionBuilder(byArray);
                    Transaction transaction = builder.build(string);
                    bufferedWriter.write(Convert.toHexString(transaction.getBytes()));
                    bufferedWriter.newLine();
                    ++n;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((BufferedReader)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((BufferedReader)object).close();
                    }
                }
            }
            System.out.println("Signed " + n + " transactions");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

