/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.HashMap;
import nxt.Nxt;
import nxt.blockchain.Attachment;
import nxt.blockchain.BlockchainImpl;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.FxtChain;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionType;
import nxt.configuration.Setup;
import nxt.db.DbIterator;
import nxt.db.DbUtils;
import nxt.dbschema.Db;
import nxt.http.JSONData;
import nxt.util.Convert;

public class TransactionTypeExplorer {
    public static void main(String[] stringArray) {
        Nxt.init(Setup.COMMAND_LINE_TOOL);
        new TransactionTypeExplorer().explore();
        Nxt.shutdown();
    }

    private void explore() {
        Object object;
        HashMap<TransactionType, Transaction> hashMap = new HashMap<TransactionType, Transaction>();
        byte by = -4;
        while (true) {
            byte by2 = 0;
            while ((object = TransactionType.findTransactionType(by, by2)) != null) {
                hashMap.put((TransactionType)object, (Transaction)null);
                by2 = (byte)(by2 + 1);
            }
            if (by2 == 0) break;
            by = (byte)(by + 1);
        }
        try {
            Connection connection = Db.db.getConnection(FxtChain.FXT.getDbSchema());
            object = connection.prepareStatement("SELECT * FROM transaction_fxt");
            BlockchainImpl blockchainImpl = BlockchainImpl.getInstance();
            Object object2 = blockchainImpl.getTransactions(FxtChain.FXT, connection, (PreparedStatement)object);
            Object object3 = null;
            try {
                while (((DbIterator)object2).hasNext()) {
                    Transaction transaction = ((DbIterator)object2).next();
                    if (hashMap.get(transaction.getType()) != null) continue;
                    this.logTransactionType(transaction);
                    hashMap.put(transaction.getType(), transaction);
                }
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object3 != null) {
                        try {
                            ((DbIterator)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        ((DbIterator)object2).close();
                    }
                }
            }
            object2 = "SELECT * FROM transaction ORDER BY block_timestamp DESC, transaction_index DESC";
            object3 = ChildChain.IGNIS;
            int n = 1000;
            int n2 = 0;
            boolean bl = false;
            while (!bl) {
                connection = Db.db.getConnection(((Chain)object3).getDbSchema());
                String string = (String)object2 + DbUtils.limitsClause(n2, n2 + n - 1);
                object = connection.prepareStatement(string);
                DbUtils.setLimits(1, (PreparedStatement)object, n2, n2 + n - 1);
                DbIterator<ChildTransactionImpl> dbIterator = blockchainImpl.getTransactions((ChildChain)object3, connection, (PreparedStatement)object);
                Throwable throwable = null;
                try {
                    if (!dbIterator.hasNext()) {
                        bl = true;
                        continue;
                    }
                    while (dbIterator.hasNext()) {
                        Transaction transaction = dbIterator.next();
                        if (hashMap.get(transaction.getType()) != null) continue;
                        this.logTransactionType(transaction);
                        hashMap.put(transaction.getType(), transaction);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dbIterator == null) continue;
                    if (throwable != null) {
                        try {
                            dbIterator.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dbIterator.close();
                    continue;
                }
                n2 += n;
            }
            hashMap.entrySet().stream().filter(entry -> entry.getValue() == null).forEach(entry -> System.out.printf("transaction type %d subtype %d name %s was never used\n", ((TransactionType)entry.getKey()).getType(), ((TransactionType)entry.getKey()).getSubtype(), ((TransactionType)entry.getKey()).getName()));
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private void logTransactionType(Transaction transaction) {
        TransactionType transactionType = transaction.getType();
        System.out.printf("type %d subtype %d name %s\n", transactionType.getType(), transactionType.getSubtype(), transactionType.getName());
        System.out.printf("json: %s\n", JSONData.transaction(transaction).toJSONString());
        System.out.printf("bytes: %s\n", Convert.toHexString(transaction.getBytes()));
        Attachment.AbstractAttachment abstractAttachment = (Attachment.AbstractAttachment)transaction.getAttachment();
        System.out.printf("attachment class %s size %d\n", abstractAttachment.getClass().getSimpleName(), abstractAttachment.getSize());
        System.out.println();
    }
}

