/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import nxt.Nxt;
import nxt.addons.JO;
import nxt.env.RuntimeEnvironment;
import nxt.util.Logger;

public class ResourceLookup {
    public static final boolean USE_SYSTEM_CLASS_LOADER = !RuntimeEnvironment.isAndroidRuntime();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JO loadJsonResource(String string) {
        try (Reader reader = ResourceLookup.loadResourceText(string);){
            if (reader == null) {
                JO jO = null;
                return jO;
            }
            JO jO = JO.parse(reader);
            return jO;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JO loadJsonResource(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader bufferedReader = Files.newBufferedReader(path);){
            JO jO = JO.parse(bufferedReader);
            return jO;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    public static Reader loadResourceText(String string) {
        InputStream inputStream = ResourceLookup.loadResourceBytes(string);
        if (inputStream == null) {
            return null;
        }
        return new InputStreamReader(inputStream);
    }

    public static InputStream loadResourceBytes(String string) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        if (inputStream != null) {
            Logger.logInfoMessage("Loading resource from classpath " + string);
            return inputStream;
        }
        Path path = Paths.get(Nxt.getUserHomeDir(), string);
        if (!Files.isReadable(path) && !Files.isReadable(path = Paths.get(string, new String[0]))) {
            Logger.logErrorMessage("file not found " + path.toAbsolutePath());
            return null;
        }
        Logger.logInfoMessage("Loading file from path " + path.toAbsolutePath());
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException iOException) {
            Logger.logErrorMessage("Cannot read json file from path " + path.toAbsolutePath(), iOException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getResourceBytes(String string) {
        try (InputStream inputStream = ResourceLookup.loadResourceBytes(string);){
            if (inputStream == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = ResourceLookup.readInputStream(inputStream);
            return byArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    public static InputStream getSystemResourceAsStream(String string) {
        if (USE_SYSTEM_CLASS_LOADER) {
            return ClassLoader.getSystemResourceAsStream(string);
        }
        return ResourceLookup.class.getClassLoader().getResourceAsStream(string);
    }

    public static byte[] readInputStream(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[16384];
        try {
            int n;
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

