/*
 * Decompiled with CFR 0.152.
 */
package nxt.util.security;

import java.security.PublicKey;
import java.security.cert.Certificate;
import nxt.blockchain.Transaction;
import nxt.crypto.Crypto;
import nxt.util.Convert;
import nxt.util.security.BlockchainPublicKey;

public class BlockchainCertificate
extends Certificate {
    Transaction transaction;
    private byte[] publicKey;
    private byte[] bytes;
    private byte[] signature;

    public BlockchainCertificate(byte[] byArray) {
        super("BlockchainCertificate");
        this.publicKey = byArray;
    }

    protected BlockchainCertificate(Transaction transaction) {
        this(transaction.getSenderPublicKey());
        this.bytes = transaction.getBytes();
        this.signature = transaction.getSignature();
        this.transaction = transaction;
    }

    @Override
    public byte[] getEncoded() {
        return this.publicKey;
    }

    @Override
    public void verify(PublicKey publicKey) {
        Crypto.verify(this.signature, this.bytes, publicKey.getEncoded());
    }

    @Override
    public void verify(PublicKey publicKey, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "BlockchainCertificate{publicKey=" + Convert.toHexString(this.publicKey) + ", bytes=" + (this.bytes == null ? "N/A" : Convert.toHexString(this.bytes)) + ", signature=" + (this.signature == null ? "N/A" : Convert.toHexString(this.signature)) + '}';
    }

    protected Object clone() throws CloneNotSupportedException {
        super.clone();
        if (this.transaction != null) {
            return new BlockchainCertificate(this.transaction);
        }
        return new BlockchainCertificate(this.publicKey);
    }

    @Override
    public PublicKey getPublicKey() {
        return new BlockchainPublicKey(this.publicKey);
    }
}

