/*
 * Decompiled with CFR 0.152.
 */
package nxt.voting;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Nxt;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.EntityDbTable;
import nxt.voting.PollHome;
import nxt.voting.VoteCastingAttachment;

public final class VoteHome {
    private static final boolean deleteProcessedVotes = Nxt.getBooleanProperty("nxt.deleteProcessedVotes");
    private final ChildChain childChain;
    private final PollHome pollHome;
    private final DbKey.HashKeyFactory<Vote> voteDbKeyFactory;
    private final EntityDbTable<Vote> voteTable;

    public static VoteHome forChain(ChildChain childChain) {
        if (childChain.getVoteHome() != null) {
            throw new IllegalStateException("already set");
        }
        return new VoteHome(childChain);
    }

    private VoteHome(ChildChain childChain) {
        this.childChain = childChain;
        this.pollHome = childChain.getPollHome();
        this.voteDbKeyFactory = new DbKey.HashKeyFactory<Vote>("full_hash", "id"){

            @Override
            public DbKey newKey(Vote vote) {
                return vote.dbKey;
            }
        };
        this.voteTable = new EntityDbTable<Vote>(childChain.getSchemaTable("vote"), this.voteDbKeyFactory){

            @Override
            protected Vote load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Vote(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Vote vote) throws SQLException {
                vote.save(connection);
            }

            @Override
            public void trim(int n) {
                super.trim(n);
                if (deleteProcessedVotes) {
                    try (Connection connection = VoteHome.this.voteTable.getConnection();
                         PreparedStatement preparedStatement = connection.prepareStatement("SELECT MIN(height) as min_height FROM vote");
                         PreparedStatement preparedStatement2 = connection.prepareStatement("DELETE FROM vote WHERE poll_id = ?");
                         ResultSet resultSet = preparedStatement.executeQuery();){
                        resultSet.next();
                        int n2 = resultSet.getInt("min_height");
                        if (!resultSet.wasNull()) {
                            DbIterator<PollHome.Poll> dbIterator = VoteHome.this.pollHome.getPollsFinishingBetween(n2, n, 0, Integer.MAX_VALUE);
                            for (PollHome.Poll poll : dbIterator) {
                                preparedStatement2.setLong(1, poll.getId());
                                preparedStatement2.executeUpdate();
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        throw new RuntimeException(sQLException.toString(), sQLException);
                    }
                }
            }
        };
    }

    public int getCount() {
        return this.voteTable.getCount();
    }

    public DbIterator<Vote> getVotes(long l, int n, int n2) {
        return this.voteTable.getManyBy(new DbClause.LongClause("poll_id", l), n, n2);
    }

    public Vote getVote(long l, long l2) {
        DbClause dbClause = new DbClause.LongClause("poll_id", l).and(new DbClause.LongClause("voter_id", l2));
        return this.voteTable.getBy(dbClause);
    }

    Vote addVote(Transaction transaction, VoteCastingAttachment voteCastingAttachment) {
        Vote vote = new Vote(transaction, voteCastingAttachment);
        this.voteTable.insert(vote);
        return vote;
    }

    public final class Vote {
        private final long id;
        private final byte[] hash;
        private final DbKey dbKey;
        private final long pollId;
        private final long voterId;
        private final byte[] voteBytes;

        private Vote(Transaction transaction, VoteCastingAttachment voteCastingAttachment) {
            this.id = transaction.getId();
            this.hash = transaction.getFullHash();
            this.dbKey = VoteHome.this.voteDbKeyFactory.newKey(this.hash, this.id);
            this.pollId = voteCastingAttachment.getPollId();
            this.voterId = transaction.getSenderId();
            this.voteBytes = voteCastingAttachment.getPollVote();
        }

        private Vote(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.id = resultSet.getLong("id");
            this.hash = resultSet.getBytes("full_hash");
            this.dbKey = dbKey;
            this.pollId = resultSet.getLong("poll_id");
            this.voterId = resultSet.getLong("voter_id");
            this.voteBytes = resultSet.getBytes("vote_bytes");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO vote (id, full_hash, poll_id, voter_id, vote_bytes, height) VALUES (?, ?, ?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setBytes(++n, this.hash);
                preparedStatement.setLong(++n, this.pollId);
                preparedStatement.setLong(++n, this.voterId);
                preparedStatement.setBytes(++n, this.voteBytes);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public long getId() {
            return this.id;
        }

        public byte[] getFullHash() {
            return this.hash;
        }

        public long getPollId() {
            return this.pollId;
        }

        public long getVoterId() {
            return this.voterId;
        }

        public byte[] getVoteBytes() {
            return this.voteBytes;
        }

        public ChildChain getChildChain() {
            return VoteHome.this.childChain;
        }
    }
}

