/*
 * Decompiled with CFR 0.152.
 */
package nxt.voting;

import java.util.Arrays;
import nxt.NxtException;
import nxt.account.Account;
import nxt.ae.Asset;
import nxt.blockchain.Chain;
import nxt.ms.Currency;

public final class VoteWeighting {
    private final VotingModel votingModel;
    private final long holdingId;
    private final long minBalance;
    private final MinBalanceModel minBalanceModel;

    public VoteWeighting(byte by, long l, long l2, byte by2) {
        this.votingModel = VotingModel.get(by);
        this.holdingId = l;
        this.minBalance = l2;
        this.minBalanceModel = MinBalanceModel.get(by2);
    }

    public VotingModel getVotingModel() {
        return this.votingModel;
    }

    public long getMinBalance() {
        return this.minBalance;
    }

    public long getHoldingId() {
        return this.holdingId;
    }

    public MinBalanceModel getMinBalanceModel() {
        return this.minBalanceModel;
    }

    public void validate() throws NxtException.ValidationException {
        if (this.votingModel == null) {
            throw new NxtException.NotValidException("Invalid voting model");
        }
        if (this.minBalanceModel == null) {
            throw new NxtException.NotValidException("Invalid min balance model");
        }
        if ((this.votingModel == VotingModel.ASSET || this.votingModel == VotingModel.CURRENCY || this.votingModel == VotingModel.COIN) && this.holdingId == 0L) {
            throw new NxtException.NotValidException("No holdingId provided");
        }
        if (this.votingModel == VotingModel.CURRENCY && Currency.getCurrency(this.holdingId) == null) {
            throw new NxtException.NotCurrentlyValidException("Currency " + Long.toUnsignedString(this.holdingId) + " not found");
        }
        if (this.votingModel == VotingModel.ASSET && Asset.getAsset(this.holdingId) == null) {
            throw new NxtException.NotCurrentlyValidException("Asset " + Long.toUnsignedString(this.holdingId) + " not found");
        }
        if (this.votingModel == VotingModel.COIN && Chain.getChain(Math.toIntExact(this.holdingId)) == null) {
            throw new NxtException.NotValidException("Chain " + this.holdingId + " not found");
        }
        if (this.minBalance < 0L) {
            throw new NxtException.NotValidException("Invalid minBalance " + this.minBalance);
        }
        if (this.minBalance > 0L) {
            if (this.minBalanceModel == MinBalanceModel.NONE) {
                throw new NxtException.NotValidException("Invalid min balance model " + (Object)((Object)this.minBalanceModel));
            }
            if (this.votingModel.getMinBalanceModel() != MinBalanceModel.NONE && this.votingModel.getMinBalanceModel() != this.minBalanceModel) {
                throw new NxtException.NotValidException("Invalid min balance model: " + (Object)((Object)this.minBalanceModel) + " for voting model " + (Object)((Object)this.votingModel));
            }
            if ((this.minBalanceModel == MinBalanceModel.ASSET || this.minBalanceModel == MinBalanceModel.CURRENCY || this.minBalanceModel == MinBalanceModel.COIN) && this.holdingId == 0L) {
                throw new NxtException.NotValidException("No holdingId provided");
            }
            if (this.minBalanceModel == MinBalanceModel.ASSET && Asset.getAsset(this.holdingId) == null) {
                throw new NxtException.NotCurrentlyValidException("Invalid min balance asset: " + Long.toUnsignedString(this.holdingId));
            }
            if (this.minBalanceModel == MinBalanceModel.CURRENCY && Currency.getCurrency(this.holdingId) == null) {
                throw new NxtException.NotCurrentlyValidException("Invalid min balance currency: " + Long.toUnsignedString(this.holdingId));
            }
            if (this.minBalanceModel == MinBalanceModel.COIN && Chain.getChain(Math.toIntExact(this.holdingId)) == null) {
                throw new NxtException.NotValidException("Chain " + this.holdingId + " not found");
            }
        }
        if (this.minBalance == 0L && this.votingModel == VotingModel.ACCOUNT && this.holdingId != 0L) {
            throw new NxtException.NotValidException("HoldingId cannot be used in by account voting with no min balance");
        }
        if (!(this.votingModel.acceptsVotes() && this.votingModel != VotingModel.HASH || this.holdingId == 0L && this.minBalance == 0L && this.minBalanceModel == MinBalanceModel.NONE)) {
            throw new NxtException.NotValidException("With VotingModel " + (Object)((Object)this.votingModel) + " no holdingId, minBalance, or minBalanceModel should be specified");
        }
    }

    public boolean isBalanceIndependent() {
        return this.votingModel == VotingModel.ACCOUNT && this.minBalance == 0L || !this.votingModel.acceptsVotes() || this.votingModel == VotingModel.HASH;
    }

    public boolean acceptsVotes() {
        return this.votingModel.acceptsVotes();
    }

    public boolean equals(Object object) {
        if (!(object instanceof VoteWeighting)) {
            return false;
        }
        VoteWeighting voteWeighting = (VoteWeighting)object;
        return voteWeighting.votingModel == this.votingModel && voteWeighting.minBalanceModel == this.minBalanceModel && voteWeighting.holdingId == this.holdingId && voteWeighting.minBalance == this.minBalance;
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + Long.hashCode(this.holdingId);
        n = 31 * n + Long.hashCode(this.minBalance);
        n = 31 * n + this.minBalanceModel.hashCode();
        n = 31 * n + this.votingModel.hashCode();
        return n;
    }

    public static enum MinBalanceModel {
        NONE(0){

            @Override
            public final long getBalance(VoteWeighting voteWeighting, long l, int n) {
                throw new UnsupportedOperationException();
            }
        }
        ,
        COIN(1){

            @Override
            public final long getBalance(VoteWeighting voteWeighting, long l, int n) {
                return Chain.getChain(Math.toIntExact(voteWeighting.holdingId)).getBalanceHome().getBalance(l, n).getBalance();
            }
        }
        ,
        ASSET(2){

            @Override
            public final long getBalance(VoteWeighting voteWeighting, long l, int n) {
                return Account.getAssetBalanceQNT(l, voteWeighting.holdingId, n);
            }
        }
        ,
        CURRENCY(3){

            @Override
            public final long getBalance(VoteWeighting voteWeighting, long l, int n) {
                return Account.getCurrencyUnits(l, voteWeighting.holdingId, n);
            }
        };

        private final byte code;

        private MinBalanceModel(int n2) {
            this.code = (byte)n2;
        }

        public byte getCode() {
            return this.code;
        }

        protected abstract long getBalance(VoteWeighting var1, long var2, int var4);

        public static MinBalanceModel get(byte by) {
            for (MinBalanceModel minBalanceModel : MinBalanceModel.values()) {
                if (minBalanceModel.getCode() != by) continue;
                return minBalanceModel;
            }
            throw new IllegalArgumentException("Invalid minBalanceModel " + by);
        }
    }

    public static enum VotingModel {
        NONE(-1){

            @Override
            public final boolean acceptsVotes() {
                return false;
            }

            @Override
            public final long calcWeight(VoteWeighting voteWeighting, long l, int n) {
                throw new UnsupportedOperationException("No voting possible for VotingModel.NONE");
            }

            @Override
            public final MinBalanceModel getMinBalanceModel() {
                return MinBalanceModel.NONE;
            }
        }
        ,
        ACCOUNT(0){

            @Override
            public final long calcWeight(VoteWeighting voteWeighting, long l, int n) {
                return voteWeighting.minBalance == 0L || voteWeighting.minBalanceModel.getBalance(voteWeighting, l, n) >= voteWeighting.minBalance ? 1L : 0L;
            }

            @Override
            public final MinBalanceModel getMinBalanceModel() {
                return MinBalanceModel.NONE;
            }
        }
        ,
        COIN(1){

            @Override
            public final long calcWeight(VoteWeighting voteWeighting, long l, int n) {
                long l2 = Chain.getChain(Math.toIntExact(voteWeighting.holdingId)).getBalanceHome().getBalance(l, n).getBalance();
                return l2 >= voteWeighting.minBalance ? l2 : 0L;
            }

            @Override
            public final MinBalanceModel getMinBalanceModel() {
                return MinBalanceModel.COIN;
            }
        }
        ,
        ASSET(2){

            @Override
            public final long calcWeight(VoteWeighting voteWeighting, long l, int n) {
                long l2 = Account.getAssetBalanceQNT(l, voteWeighting.holdingId, n);
                return l2 >= voteWeighting.minBalance ? l2 : 0L;
            }

            @Override
            public final MinBalanceModel getMinBalanceModel() {
                return MinBalanceModel.ASSET;
            }
        }
        ,
        CURRENCY(3){

            @Override
            public final long calcWeight(VoteWeighting voteWeighting, long l, int n) {
                long l2 = Account.getCurrencyUnits(l, voteWeighting.holdingId, n);
                return l2 >= voteWeighting.minBalance ? l2 : 0L;
            }

            @Override
            public final MinBalanceModel getMinBalanceModel() {
                return MinBalanceModel.CURRENCY;
            }
        }
        ,
        TRANSACTION(4){

            @Override
            public final boolean acceptsVotes() {
                return false;
            }

            @Override
            public final long calcWeight(VoteWeighting voteWeighting, long l, int n) {
                throw new UnsupportedOperationException("No voting possible for VotingModel.TRANSACTION");
            }

            @Override
            public final MinBalanceModel getMinBalanceModel() {
                return MinBalanceModel.NONE;
            }
        }
        ,
        HASH(5){

            @Override
            public final long calcWeight(VoteWeighting voteWeighting, long l, int n) {
                return 1L;
            }

            @Override
            public final MinBalanceModel getMinBalanceModel() {
                return MinBalanceModel.NONE;
            }
        }
        ,
        COMPOSITE(6){

            @Override
            public long calcWeight(VoteWeighting voteWeighting, long l, int n) {
                throw new UnsupportedOperationException("Vote weighting for VotingModel.COMPOSITE should be handled explicitly");
            }

            @Override
            public MinBalanceModel getMinBalanceModel() {
                return MinBalanceModel.NONE;
            }
        }
        ,
        PROPERTY(7){

            @Override
            public final boolean acceptsVotes() {
                return false;
            }

            @Override
            public final long calcWeight(VoteWeighting voteWeighting, long l, int n) {
                throw new UnsupportedOperationException("No voting possible for VotingModel.PROPERTY");
            }

            @Override
            public final MinBalanceModel getMinBalanceModel() {
                return MinBalanceModel.NONE;
            }
        };

        private final byte code;
        public static final int MIN_CODE;
        public static final int MAX_CODE;

        private VotingModel(int n2) {
            this.code = (byte)n2;
        }

        public byte getCode() {
            return this.code;
        }

        public abstract long calcWeight(VoteWeighting var1, long var2, int var4);

        public abstract MinBalanceModel getMinBalanceModel();

        public boolean acceptsVotes() {
            return true;
        }

        public static VotingModel get(byte by) {
            for (VotingModel votingModel : VotingModel.values()) {
                if (votingModel.getCode() != by) continue;
                return votingModel;
            }
            throw new IllegalArgumentException("Invalid votingModel " + by);
        }

        static {
            MIN_CODE = Arrays.stream(VotingModel.values()).mapToInt(VotingModel::getCode).min().getAsInt();
            MAX_CODE = Arrays.stream(VotingModel.values()).mapToInt(VotingModel::getCode).max().getAsInt();
        }
    }
}

