/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.security.AccessController;
import java.util.Properties;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.BlockchainImpl;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.BlockchainProcessorImpl;
import nxt.blockchain.Generator;
import nxt.blockchain.TransactionProcessorImpl;
import nxt.configuration.Setup;
import nxt.crypto.Crypto;
import nxt.util.Listener;
import nxt.util.Logger;
import org.junit.Assert;

public abstract class AbstractBlockchainTest {
    protected static BlockchainProcessorImpl blockchainProcessor;
    protected static BlockchainImpl blockchain;
    private static final Object doneLock;
    private static boolean done;

    protected static Properties newTestProperties() {
        Properties properties = new Properties();
        properties.setProperty("nxt.shareMyAddress", "false");
        properties.setProperty("nxt.savePeers", "false");
        properties.setProperty("nxt.disableGenerateBlocksThread", "true");
        properties.setProperty("nxt.testUnconfirmedTransactions", "true");
        properties.setProperty("nxt.debugTraceAccounts", "");
        properties.setProperty("nxt.debugLogUnconfirmed", "false");
        properties.setProperty("nxt.debugTraceQuote", "\"");
        properties.setProperty("nxt.runtime.mode", "");
        return properties;
    }

    protected static void init(Properties properties) {
        AccessController.doPrivileged(() -> {
            Nxt.init((Setup)Setup.UNIT_TEST, (Properties)properties);
            return null;
        });
        blockchain = BlockchainImpl.getInstance();
        blockchainProcessor = BlockchainProcessorImpl.getInstance();
        blockchainProcessor.setGetMoreBlocks(false);
        TransactionProcessorImpl.getInstance().clearUnconfirmedTransactions();
        Listener listener = block -> {
            if (block.getHeight() % 1000 == 0) {
                Logger.logMessage((String)("downloaded block " + block.getHeight()));
            }
        };
        blockchainProcessor.addListener(listener, BlockchainProcessor.Event.BLOCK_PUSHED);
    }

    protected static void shutdown() {
        TransactionProcessorImpl.getInstance().clearUnconfirmedTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void downloadTo(int n) {
        if (blockchain.getHeight() == n) {
            return;
        }
        Assert.assertTrue((blockchain.getHeight() < n ? 1 : 0) != 0);
        Listener listener = block -> {
            if (blockchain.getHeight() == n) {
                Object object = doneLock;
                synchronized (object) {
                    done = true;
                    blockchainProcessor.setGetMoreBlocks(false);
                    doneLock.notifyAll();
                    throw new NxtException.StopException("Reached height " + n);
                }
            }
        };
        blockchainProcessor.addListener(listener, BlockchainProcessor.Event.BLOCK_PUSHED);
        Object object = doneLock;
        synchronized (object) {
            done = false;
            Logger.logMessage((String)("Starting download from height " + blockchain.getHeight()));
            blockchainProcessor.setGetMoreBlocks(true);
            while (!done) {
                try {
                    doneLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        Assert.assertEquals((long)n, (long)blockchain.getHeight());
        blockchainProcessor.removeListener(listener, BlockchainProcessor.Event.BLOCK_PUSHED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void forgeTo(int n, String string) {
        if (blockchain.getHeight() == n) {
            return;
        }
        Assert.assertTrue((blockchain.getHeight() < n ? 1 : 0) != 0);
        Listener listener = block -> {
            if (blockchain.getHeight() == n) {
                Object object = doneLock;
                synchronized (object) {
                    done = true;
                    Generator.stopForging((String)string);
                    doneLock.notifyAll();
                }
            }
        };
        blockchainProcessor.addListener(listener, BlockchainProcessor.Event.BLOCK_PUSHED);
        Object object = doneLock;
        synchronized (object) {
            done = false;
            Logger.logMessage((String)("Starting forging from height " + blockchain.getHeight()));
            Generator.startForging((String)string);
            while (!done) {
                try {
                    doneLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        Assert.assertTrue((blockchain.getHeight() >= n ? 1 : 0) != 0);
        Assert.assertArrayEquals((byte[])Crypto.getPublicKey((String)string), (byte[])blockchain.getLastBlock().getGeneratorPublicKey());
        blockchainProcessor.removeListener(listener, BlockchainProcessor.Event.BLOCK_PUSHED);
    }

    protected int getHeight() {
        return blockchain.getHeight();
    }

    static {
        doneLock = new Object();
        done = false;
    }
}

