/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import junit.runner.Version;
import org.junit.internal.JUnitSystem;
import org.junit.internal.RealSystem;
import org.junit.internal.TextListener;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnitCoreWithListeners
extends JUnitCore {
    public static void main(String[] stringArray) {
        JUnitCoreWithListeners.runMainAndExit((JUnitSystem)new RealSystem(), stringArray);
    }

    private static void runMainAndExit(JUnitSystem jUnitSystem, String ... stringArray) {
        JUnitCoreWithListeners jUnitCoreWithListeners = new JUnitCoreWithListeners();
        jUnitCoreWithListeners.addListener((RunListener)new TextListener(jUnitSystem));
        MyLogger myLogger = (string, objectArray) -> System.out.println(String.format(string, objectArray));
        jUnitCoreWithListeners.addListener(new LoggingListener(myLogger));
        Result result = jUnitCoreWithListeners.runMain(jUnitSystem, stringArray);
        System.exit(result.wasSuccessful() ? 0 : 1);
    }

    private Result runMain(JUnitSystem jUnitSystem, String ... textListener) {
        jUnitSystem.out().println("JUnit version " + Version.id());
        ArrayList arrayList = new ArrayList();
        ArrayList<Failure> arrayList2 = new ArrayList<Failure>();
        for (TextListener string : textListener) {
            try {
                arrayList.add(Class.forName((String)string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                jUnitSystem.out().println("Could not find class: " + (String)string);
                Description description = Description.createSuiteDescription((String)string, (Annotation[])new Annotation[0]);
                Failure failure = new Failure(description, (Throwable)classNotFoundException);
                arrayList2.add(failure);
            }
        }
        TextListener textListener2 = new TextListener(jUnitSystem);
        this.addListener((RunListener)textListener2);
        Result result = this.run(arrayList.toArray(new Class[0]));
        for (Failure failure : arrayList2) {
            result.getFailures().add(failure);
        }
        return result;
    }

    private static class LoggingListener
    extends RunListener {
        private final MyLogger logger;

        private LoggingListener(MyLogger myLogger) {
            this.logger = myLogger;
        }

        public void testRunStarted(Description description) {
            this.logger.log("Test Run started %s", description.getDisplayName());
        }

        public void testRunFinished(Result result) {
            int n = result.getFailureCount();
            int n2 = result.getIgnoreCount();
            if (n == 0 && n2 == 0) {
                this.logger.log("Test Run finished, took %s ms (tests passed: %s)", result.getRunTime(), result.getRunCount());
            } else {
                this.logger.log("Test Run finished, took %s ms (tests passed: %s, failed: %s, ignored: %s)", result.getRunTime(), result.getRunCount(), n, n2);
            }
        }

        public void testStarted(Description description) {
            this.logger.log("Test started %s", description.getDisplayName());
        }

        public void testFinished(Description description) {
            this.logger.log("Test finished %s", description.getDisplayName());
        }

        public void testFailure(Failure failure) {
            this.logger.log("Test Failed %s, reason: %s", failure.getDescription().getDisplayName(), failure.getTrace());
        }

        public void testAssumptionFailure(Failure failure) {
            this.logger.log("Test ignored with assumption %s", failure.getDescription().getDisplayName());
        }

        public void testIgnored(Description description) {
            this.logger.log("Test ignored %s", description.getDisplayName());
        }
    }

    @FunctionalInterface
    private static interface MyLogger {
        public void log(String var1, Object ... var2);
    }
}

