/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Locale;
import nxt.crypto.HashFunction;
import nxt.ms.CurrencyMinting;
import nxt.util.Convert;
import nxt.util.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TestMintCalculations {
    @Test
    public void targetCalculation() {
        byte[] byArray = CurrencyMinting.getTarget((int)4, (int)32, (long)1L, (long)0L, (long)100000L);
        Logger.logDebugMessage((String)("initial target: " + Arrays.toString(byArray)));
        Assert.assertEquals((long)32L, (long)byArray.length);
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15}, (byte[])byArray);
        byArray = CurrencyMinting.getTarget((int)4, (int)32, (long)1L, (long)50000L, (long)100000L);
        Logger.logDebugMessage((String)("midway target: " + Arrays.toString(byArray)));
        Assert.assertEquals((long)32L, (long)byArray.length);
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 63, 0, 0}, (byte[])byArray);
        byArray = CurrencyMinting.getTarget((int)4, (int)32, (long)1L, (long)100000L, (long)100000L);
        Logger.logDebugMessage((String)("final target: " + Arrays.toString(byArray)));
        Assert.assertEquals((long)32L, (long)byArray.length);
        Assert.assertArrayEquals((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0}, (byte[])byArray);
        byArray = CurrencyMinting.getTarget((int)4, (int)32, (long)100L, (long)100000L, (long)100000L);
        Logger.logDebugMessage((String)("final target for 100 units: " + Arrays.toString(byArray)));
        Assert.assertEquals((long)32L, (long)byArray.length);
        Assert.assertArrayEquals((byte[])new byte[]{92, -113, -62, -11, 40, 92, -113, -62, -11, 40, 92, -113, -62, -11, 40, 92, -113, -62, -11, 40, 92, -113, -62, -11, 40, 92, -113, 2, 0, 0, 0, 0}, (byte[])byArray);
        try {
            CurrencyMinting.getTarget((int)0, (int)5, (long)1L, (long)0L, (long)100000L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.logDebugMessage((String)"Difficulty too low");
        }
    }

    @Test
    public void hashing() {
        long l;
        for (l = 0L; l < Long.MAX_VALUE && !CurrencyMinting.meetsTarget((byte[])CurrencyMinting.getHash((byte)HashFunction.Keccak25.getId(), (long)l, (long)123L, (long)1L, (long)1L, (long)987L), (byte[])CurrencyMinting.getTarget((int)8, (int)16, (long)1L, (long)0L, (long)100000L)); ++l) {
        }
        Assert.assertEquals((long)149L, (long)l);
        for (l = 0L; l < Long.MAX_VALUE && !CurrencyMinting.meetsTarget((byte[])CurrencyMinting.getHash((byte)HashFunction.Keccak25.getId(), (long)l, (long)123L, (long)1L, (long)1L, (long)987L), (byte[])CurrencyMinting.getTarget((int)8, (int)16, (long)1L, (long)100000L, (long)100000L)); ++l) {
        }
        Assert.assertEquals((long)120597L, (long)l);
        for (l = 0L; l < Long.MAX_VALUE && !CurrencyMinting.meetsTarget((byte[])CurrencyMinting.getHash((byte)HashFunction.Keccak25.getId(), (long)l, (long)123L, (long)100L, (long)1L, (long)987L), (byte[])CurrencyMinting.getTarget((int)8, (int)16, (long)100L, (long)0L, (long)100000L)); ++l) {
        }
        Assert.assertEquals((long)5123L, (long)l);
    }

    @Test
    public void sha256() {
        byte[] byArray = HashFunction.SHA256.hash(new byte[]{97, 98, 99});
        Assert.assertEquals((Object)"ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad", (Object)Convert.toHexString((byte[])byArray));
        byArray = HashFunction.SHA256.hash(new byte[0]);
        Assert.assertEquals((Object)"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855", (Object)Convert.toHexString((byte[])byArray));
    }

    @Test
    public void sha3() {
        byte[] byArray = HashFunction.SHA3.hash(new byte[]{65, -5});
        Assert.assertEquals((Object)"A8EACEDA4D47B3281A795AD9E1EA2122B407BAF9AABCB9E18B5717B7873537D2".toLowerCase(Locale.ROOT), (Object)Convert.toHexString((byte[])byArray));
        byArray = HashFunction.SHA3.hash(new byte[0]);
        Assert.assertEquals((Object)"c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470", (Object)Convert.toHexString((byte[])byArray));
    }

    @Test
    public void scrypt() {
        byte[] byArray = HashFunction.SCRYPT.hash(new byte[]{65, -5});
        Assert.assertEquals((Object)"da3f4f010d772567a8896465d11df28693b244c91b8ba4bea5a30f6be572b667".toLowerCase(Locale.ROOT), (Object)Convert.toHexString((byte[])byArray));
        byArray = HashFunction.SCRYPT.hash(new byte[0]);
        Assert.assertEquals((Object)"413cd8c7202bba7ebce0c5aab6c0928eb5894052e0a494c8671e482583ecdea2", (Object)Convert.toHexString((byte[])byArray));
    }

    @Test
    public void scryptInterCallCleanup() {
        HashFunction.SCRYPT.hash(new byte[]{65, -5, 1});
        byte[] byArray = HashFunction.SCRYPT.hash(new byte[]{65, -5});
        Assert.assertEquals((Object)"da3f4f010d772567a8896465d11df28693b244c91b8ba4bea5a30f6be572b667".toLowerCase(Locale.ROOT), (Object)Convert.toHexString((byte[])byArray));
    }

    @Test
    public void lowDifficultyProblem() {
        BigInteger bigInteger = CurrencyMinting.getNumericTarget((int)1, (int)255, (long)1L, (long)0L, (long)100000L);
        byte[] byArray = bigInteger.toByteArray();
        Assert.assertEquals((long)32L, (long)byArray.length);
        bigInteger = CurrencyMinting.getNumericTarget((int)2, (int)255, (long)1L, (long)0L, (long)100000L);
        byArray = bigInteger.toByteArray();
        Assert.assertEquals((long)32L, (long)byArray.length);
        bigInteger = CurrencyMinting.getNumericTarget((int)254, (int)255, (long)1L, (long)0L, (long)100000L);
        byArray = bigInteger.toByteArray();
        Assert.assertEquals((long)1L, (long)byArray.length);
        bigInteger = CurrencyMinting.getNumericTarget((int)1, (int)255, (long)1L, (long)100000L, (long)100000L);
        byArray = bigInteger.toByteArray();
        Assert.assertEquals((long)1L, (long)byArray.length);
        bigInteger = CurrencyMinting.getNumericTarget((int)2, (int)255, (long)1L, (long)100000L, (long)100000L);
        byArray = bigInteger.toByteArray();
        Assert.assertEquals((long)1L, (long)byArray.length);
        bigInteger = CurrencyMinting.getNumericTarget((int)254, (int)255, (long)1L, (long)100000L, (long)100000L);
        byArray = bigInteger.toByteArray();
        Assert.assertEquals((long)1L, (long)byArray.length);
    }
}

