/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import nxt.account.Account;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtChain;
import nxt.crypto.Crypto;
import nxt.db.DbIterator;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public class Tester {
    private final String secretPhrase;
    private final byte[] privateKey;
    private final byte[] publicKey;
    private final String publicKeyStr;
    private final long id;
    private final String strId;
    private final String rsAccount;
    private final long initialFxtBalance;
    private final long initialFxtUnconfirmedBalance;
    private final long initialFxtEffectiveBalance;
    private final Map<Integer, Long> initialChainBalance = new HashMap<Integer, Long>();
    private final Map<Integer, Long> initialChainUnconfirmedBalance = new HashMap<Integer, Long>();
    private final Map<Long, Long> initialAssetQuantity = new HashMap<Long, Long>();
    private final Map<Long, Long> initialUnconfirmedAssetQuantity = new HashMap<Long, Long>();
    private final Map<Long, Long> initialCurrencyUnits = new HashMap<Long, Long>();
    private final Map<Long, Long> initialUnconfirmedCurrencyUnits = new HashMap<Long, Long>();

    public Tester(String string) {
        this.secretPhrase = string;
        this.privateKey = Crypto.getPrivateKey((String)string);
        this.publicKey = Crypto.getPublicKey((String)string);
        this.publicKeyStr = Convert.toHexString((byte[])this.publicKey);
        this.id = Account.getId((byte[])this.publicKey);
        this.strId = Long.toUnsignedString(this.id);
        this.rsAccount = Convert.rsAccount((long)this.id);
        Account account = AccessController.doPrivileged(() -> Account.getAccount((byte[])this.publicKey));
        if (account != null) {
            Object object3;
            Object object22;
            this.initialFxtBalance = FxtChain.FXT.getBalanceHome().getBalance(account.getId()).getBalance();
            this.initialFxtUnconfirmedBalance = FxtChain.FXT.getBalanceHome().getBalance(account.getId()).getUnconfirmedBalance();
            this.initialFxtEffectiveBalance = account.getEffectiveBalanceFXT();
            for (Object object22 : ChildChain.getAll()) {
                this.initialChainBalance.put(object22.getId(), object22.getBalanceHome().getBalance(account.getId()).getBalance());
                this.initialChainUnconfirmedBalance.put(object22.getId(), object22.getBalanceHome().getBalance(account.getId()).getUnconfirmedBalance());
            }
            DbIterator dbIterator = account.getAssets(0, -1);
            for (Object object3 : dbIterator) {
                this.initialAssetQuantity.put(object3.getAssetId(), object3.getQuantityQNT());
                this.initialUnconfirmedAssetQuantity.put(object3.getAssetId(), object3.getUnconfirmedQuantityQNT());
            }
            object22 = account.getCurrencies(0, -1);
            object3 = object22.iterator();
            while (object3.hasNext()) {
                Account.AccountCurrency accountCurrency = (Account.AccountCurrency)object3.next();
                this.initialCurrencyUnits.put(accountCurrency.getCurrencyId(), accountCurrency.getUnits());
                this.initialUnconfirmedCurrencyUnits.put(accountCurrency.getCurrencyId(), accountCurrency.getUnconfirmedUnits());
            }
        } else {
            this.initialFxtBalance = 0L;
            this.initialFxtUnconfirmedBalance = 0L;
            this.initialFxtEffectiveBalance = 0L;
            for (Chain chain : ChildChain.getAll()) {
                this.initialChainBalance.put(chain.getId(), 0L);
                this.initialChainUnconfirmedBalance.put(chain.getId(), 0L);
            }
        }
    }

    public static String responseToStringId(JSONObject jSONObject) {
        return Tester.responseToStringId(jSONObject, "fullHash");
    }

    public static String responseToStringId(JSONObject jSONObject, String string) {
        return Tester.hexFullHashToStringId((String)jSONObject.get((Object)string));
    }

    public static String hexFullHashToStringId(String string) {
        return Long.toUnsignedString(Convert.fullHashToId((byte[])Convert.parseHexString((String)string)));
    }

    public String getSecretPhrase() {
        return this.secretPhrase;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public String getPublicKeyStr() {
        return this.publicKeyStr;
    }

    public Account getAccount() {
        return AccessController.doPrivileged(() -> Account.getAccount((byte[])this.publicKey));
    }

    public long getId() {
        return this.id;
    }

    public String getStrId() {
        return this.strId;
    }

    public String getRsAccount() {
        return this.rsAccount;
    }

    public long getFxtBalanceDiff() {
        return AccessController.doPrivileged(() -> FxtChain.FXT.getBalanceHome().getBalance(this.id).getBalance() - this.initialFxtBalance);
    }

    public long getFxtUnconfirmedBalanceDiff() {
        return AccessController.doPrivileged(() -> FxtChain.FXT.getBalanceHome().getBalance(this.id).getUnconfirmedBalance() - this.initialFxtUnconfirmedBalance);
    }

    public long getInitialFxtBalance() {
        return this.initialFxtBalance;
    }

    public long getFxtBalance() {
        return AccessController.doPrivileged(() -> FxtChain.FXT.getBalanceHome().getBalance(this.id).getBalance());
    }

    public long getChainBalanceDiff(int n) {
        return AccessController.doPrivileged(() -> Chain.getChain((int)n).getBalanceHome().getBalance(this.id).getBalance() - this.initialChainBalance.get(n));
    }

    public long getChainUnconfirmedBalanceDiff(int n) {
        return AccessController.doPrivileged(() -> Chain.getChain((int)n).getBalanceHome().getBalance(this.id).getUnconfirmedBalance() - this.initialChainUnconfirmedBalance.get(n));
    }

    public long getInitialChainBalance(int n) {
        return this.initialChainBalance.get(n);
    }

    public long getChainBalance(int n) {
        return AccessController.doPrivileged(() -> Chain.getChain((int)n).getBalanceHome().getBalance(this.id).getBalance());
    }

    public long getAssetQuantityDiff(long l) {
        return AccessController.doPrivileged(() -> Account.getAccount((long)this.id).getAssetBalanceQNT(l) - this.getInitialAssetQuantity(l));
    }

    public long getUnconfirmedAssetQuantityDiff(long l) {
        return AccessController.doPrivileged(() -> Account.getAccount((long)this.id).getUnconfirmedAssetBalanceQNT(l) - this.getInitialAssetQuantity(l));
    }

    public long getCurrencyUnitsDiff(long l) {
        return AccessController.doPrivileged(() -> Account.getAccount((long)this.id).getCurrencyUnits(l) - this.getInitialCurrencyUnits(l));
    }

    public long getUnconfirmedCurrencyUnitsDiff(long l) {
        return AccessController.doPrivileged(() -> Account.getAccount((long)this.id).getUnconfirmedCurrencyUnits(l) - this.getInitialUnconfirmedCurrencyUnits(l));
    }

    public long getInitialFxtUnconfirmedBalance() {
        return this.initialFxtUnconfirmedBalance;
    }

    public long getInitialFxtEffectiveBalance() {
        return this.initialFxtEffectiveBalance;
    }

    public long getInitialAssetQuantity(long l) {
        return Convert.nullToZero((Long)this.initialAssetQuantity.get(l));
    }

    public long getInitialUnconfirmedAssetQuantity(long l) {
        return Convert.nullToZero((Long)this.initialUnconfirmedAssetQuantity.get(l));
    }

    public long getInitialCurrencyUnits(long l) {
        return Convert.nullToZero((Long)this.initialCurrencyUnits.get(l));
    }

    public long getCurrencyUnits(long l) {
        return AccessController.doPrivileged(() -> this.getAccount().getCurrencyUnits(l));
    }

    public long getInitialUnconfirmedCurrencyUnits(long l) {
        return Convert.nullToZero((Long)this.initialUnconfirmedCurrencyUnits.get(l));
    }
}

