/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nxt.BlockchainTest;
import nxt.Tester;
import nxt.account.HoldingType;
import nxt.addons.JA;
import nxt.addons.JO;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtChain;
import nxt.http.APICall;
import nxt.http.callers.GetShufflersCall;
import nxt.http.shuffling.ShufflingUtil;
import nxt.shuffling.ShufflingParticipantHome;
import nxt.shuffling.ShufflingStage;
import nxt.util.Convert;
import nxt.util.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class StandbyShufflingTest
extends BlockchainTest {
    private static final String recipient1SecretPhrase = "ZFRvcc_2gEBtAZHr9Y9aVEJWYGedt91veClwKHTePQq5kNsLkL";
    private static final String recipient2SecretPhrase = "Q_O-8IHc2yE_oahBIW_q0NmEQerVOQW9q-iPeKd4ArPAFcpliI";
    private static final String recipient3SecretPhrase = "f2PpG_t8Fa7OJxiL9my3jij2aV-HY-hmLDeOMqcafjJGRJXnFK";
    private static final String recipient4SecretPhrase = "1Qqb9eXuQHumsIEQVPEO1GRrZQXyV_xq3mZfJNRoJt17gqKAxp";
    private static final String recipient5SecretPhrase = "V6anxZWGtktMW8Uo8fllVQik9Hg4008yDK8JbS_rJvLfxmOrlo";
    private static Tester RECIPIENT1;
    private static Tester RECIPIENT2;
    private static Tester RECIPIENT3;
    private static Tester RECIPIENT4;
    private static Tester RECIPIENT5;

    @BeforeClass
    public static void init() {
        AccessController.doPrivileged(() -> {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("nxt.addOns", "nxt.addons.StandbyShuffling");
            hashMap.put("nxt.disableSecurityPolicy", "true");
            StandbyShufflingTest.initNxt(hashMap);
            StandbyShufflingTest.initBlockchainTest();
            RECIPIENT1 = new Tester(recipient1SecretPhrase);
            RECIPIENT2 = new Tester(recipient2SecretPhrase);
            RECIPIENT3 = new Tester(recipient3SecretPhrase);
            RECIPIENT4 = new Tester(recipient4SecretPhrase);
            RECIPIENT5 = new Tester(recipient5SecretPhrase);
            return null;
        });
    }

    private static List<String> allRecipientsPublicKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(RECIPIENT1.getPublicKeyStr());
        arrayList.add(RECIPIENT2.getPublicKeyStr());
        arrayList.add(RECIPIENT3.getPublicKeyStr());
        arrayList.add(RECIPIENT4.getPublicKeyStr());
        arrayList.add(RECIPIENT5.getPublicKeyStr());
        return arrayList;
    }

    @After
    public void stopAll() {
        JO jO = new APICall.Builder("stopStandbyShuffler").call();
        Logger.logDebugMessage((String)"Stopped %d StandbyShufflers.", (Object[])new Object[]{jO.get("stopped")});
        Assert.assertNotNull((Object)jO.get("stopped"));
        jO = new APICall.Builder("stopShuffler").call();
        Assert.assertTrue((boolean)jO.getBoolean("stoppedAllShufflers"));
        Logger.logDebugMessage((String)"Stopped all Shufflers.");
    }

    @Test
    public void startCoin() {
        List<String> list = StandbyShufflingTest.allRecipientsPublicKeys();
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).feeRateNQTPerFXT(0L).param("recipientPublicKeys", list).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        Assert.assertTrue((boolean)jO.getBoolean("started"));
        JO jO2 = jO.getJo("standbyShuffler");
        Assert.assertNotNull((Object)jO2);
        Assert.assertEquals((long)ALICE.getId(), (long)jO2.getEntityId("account"));
        Assert.assertEquals((Object)ALICE.getRsAccount(), (Object)jO2.getString("accountRS"));
        Assert.assertEquals((long)ChildChain.IGNIS.getId(), (long)jO2.getInt("chain"));
        Assert.assertEquals((long)HoldingType.COIN.getCode(), (long)jO2.getByte("holdingType"));
        Assert.assertEquals((long)ChildChain.IGNIS.getId(), (long)jO2.getInt("holding"));
        Assert.assertEquals((Object)"0", (Object)jO2.getString("minAmount"));
        Assert.assertEquals((Object)"0", (Object)jO2.getString("maxAmount"));
        Assert.assertEquals((long)3L, (long)jO2.getInt("minParticipants"));
        Assert.assertEquals(list, (Object)jO2.get("recipientPublicKeys"));
    }

    @Test
    public void startAsset() {
        List<String> list = StandbyShufflingTest.allRecipientsPublicKeys();
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.ASSET.getCode()).param("holding", "4348103880042995903").feeRateNQTPerFXT(0L).param("recipientPublicKeys", list).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        Assert.assertTrue((boolean)jO.getBoolean("started"));
        JO jO2 = jO.getJo("standbyShuffler");
        Assert.assertNotNull((Object)jO2);
        Assert.assertEquals((long)ALICE.getId(), (long)jO2.getEntityId("account"));
        Assert.assertEquals((Object)ALICE.getRsAccount(), (Object)jO2.getString("accountRS"));
        Assert.assertEquals((long)ChildChain.IGNIS.getId(), (long)jO2.getInt("chain"));
        Assert.assertEquals((long)HoldingType.ASSET.getCode(), (long)jO2.getByte("holdingType"));
        Assert.assertEquals((Object)"4348103880042995903", (Object)jO2.getString("holding"));
        Assert.assertEquals((Object)"0", (Object)jO2.getString("minAmount"));
        Assert.assertEquals((Object)"0", (Object)jO2.getString("maxAmount"));
        Assert.assertEquals((long)3L, (long)jO2.getInt("minParticipants"));
        Assert.assertEquals(list, (Object)jO2.get("recipientPublicKeys"));
    }

    @Test
    public void startCurrency() {
        List<String> list = StandbyShufflingTest.allRecipientsPublicKeys();
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.CURRENCY.getCode()).param("holding", "1").feeRateNQTPerFXT(0L).param("recipientPublicKeys", list).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        Assert.assertTrue((boolean)jO.getBoolean("started"));
        JO jO2 = jO.getJo("standbyShuffler");
        Assert.assertNotNull((Object)jO2);
        Assert.assertEquals((long)ALICE.getId(), (long)jO2.getEntityId("account"));
        Assert.assertEquals((Object)ALICE.getRsAccount(), (Object)jO2.getString("accountRS"));
        Assert.assertEquals((long)ChildChain.IGNIS.getId(), (long)jO2.getInt("chain"));
        Assert.assertEquals((long)HoldingType.CURRENCY.getCode(), (long)jO2.getByte("holdingType"));
        Assert.assertEquals((Object)"1", (Object)jO2.getString("holding"));
        Assert.assertEquals((Object)"0", (Object)jO2.getString("minAmount"));
        Assert.assertEquals((Object)"0", (Object)jO2.getString("maxAmount"));
        Assert.assertEquals((long)3L, (long)jO2.getInt("minParticipants"));
        Assert.assertEquals(list, (Object)jO2.get("recipientPublicKeys"));
    }

    @Test
    public void startUnknownChain() {
        JO jO = new APICall.Builder("startStandbyShuffler").chain(FxtChain.FXT.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).feeRateNQTPerFXT(0L).param("recipientPublicKeys", StandbyShufflingTest.allRecipientsPublicKeys()).call();
        Assert.assertEquals((long)5L, (long)jO.getInt("errorCode"));
    }

    @Test
    public void startUnknownAccount() {
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase("an unknown account secret phrase").param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).feeRateNQTPerFXT(0L).param("recipientPublicKeys", StandbyShufflingTest.allRecipientsPublicKeys()).call();
        Assert.assertEquals((long)5L, (long)jO.getInt("errorCode"));
    }

    @Test
    public void startIncorrectHoldingType() {
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase("an unknown account secret phrase").param("holdingType", 42).param("holding", ChildChain.IGNIS.getId()).feeRateNQTPerFXT(0L).param("recipientPublicKeys", StandbyShufflingTest.allRecipientsPublicKeys()).call();
        Assert.assertEquals((long)4L, (long)jO.getInt("errorCode"));
    }

    @Test
    public void startIncorrectHoldingCoin() {
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", "42").feeRateNQTPerFXT(0L).param("recipientPublicKeys", StandbyShufflingTest.allRecipientsPublicKeys()).call();
        Assert.assertEquals((long)4L, (long)jO.getInt("errorCode"));
    }

    @Test
    public void startIncorrectPublicKey() {
        byte[] byArray = new byte[4];
        Arrays.fill(byArray, (byte)0);
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).feeRateNQTPerFXT(0L).param("recipientPublicKeys", Collections.singletonList(Convert.toHexString((byte[])byArray))).call();
        Assert.assertEquals((long)4L, (long)jO.getInt("errorCode"));
    }

    @Test
    public void startUsedPublicKey() {
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).feeRateNQTPerFXT(0L).param("recipientPublicKeys", Collections.singletonList(BOB.getPublicKeyStr())).call();
        Assert.assertEquals((long)4L, (long)jO.getInt("errorCode"));
    }

    @Test
    public void startUnknownAsset() {
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.ASSET.getCode()).param("holding", 42).feeRateNQTPerFXT(0L).param("recipientPublicKeys", StandbyShufflingTest.allRecipientsPublicKeys()).call();
        Assert.assertEquals((long)5L, (long)jO.getInt("errorCode"));
    }

    @Test
    public void startMinParticipantsZero() {
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).param("minParticipants", 0).feeRateNQTPerFXT(0L).param("recipientPublicKeys", StandbyShufflingTest.allRecipientsPublicKeys()).call();
        Assert.assertEquals((long)4L, (long)jO.getInt("errorCode"));
    }

    @Test
    public void startUnknownCurrency() {
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.CURRENCY.getCode()).param("holding", 999999).feeRateNQTPerFXT(0L).param("recipientPublicKeys", StandbyShufflingTest.allRecipientsPublicKeys()).call();
        Assert.assertEquals((long)5L, (long)jO.getInt("errorCode"));
    }

    @Test
    public void stop() {
        List<String> list = StandbyShufflingTest.allRecipientsPublicKeys();
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).feeRateNQTPerFXT(0L).param("recipientPublicKeys", list).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        Assert.assertTrue((boolean)jO.getBoolean("started"));
        jO = new APICall.Builder("stopStandbyShuffler").chain(ChildChain.IGNIS.getId()).unsignedLongParam("account", ALICE.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        Assert.assertEquals((long)1L, (long)jO.getInt("stopped"));
        JA jA = this.getAllStandbyShufflers();
        Assert.assertTrue((boolean)jA.isEmpty());
    }

    @Test
    public void get() {
        List<String> list = StandbyShufflingTest.allRecipientsPublicKeys();
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).feeRateNQTPerFXT(0L).param("recipientPublicKeys", list).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        Assert.assertTrue((boolean)jO.getBoolean("started"));
        jO = new APICall.Builder("getStandbyShufflers").chain(ChildChain.IGNIS.getId()).unsignedLongParam("account", ALICE.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        JA jA = jO.getArray("standbyShufflers");
        Assert.assertNotNull((Object)jA);
        Assert.assertEquals((long)1L, (long)jA.size());
        JO jO2 = jA.get(0);
        Assert.assertNotNull((Object)jO2);
        Assert.assertEquals((long)ALICE.getId(), (long)jO2.getEntityId("account"));
        Assert.assertEquals((Object)ALICE.getRsAccount(), (Object)jO2.getString("accountRS"));
        Assert.assertEquals((long)ChildChain.IGNIS.getId(), (long)jO2.getInt("chain"));
        Assert.assertEquals((long)HoldingType.COIN.getCode(), (long)jO2.getByte("holdingType"));
        Assert.assertEquals((long)ChildChain.IGNIS.getId(), (long)jO2.getInt("holding"));
        Assert.assertEquals((Object)"0", (Object)jO2.getString("minAmount"));
        Assert.assertEquals((Object)"0", (Object)jO2.getString("maxAmount"));
        Assert.assertEquals((long)3L, (long)jO2.getInt("minParticipants"));
        Assert.assertEquals(list, (Object)jO2.get("recipientPublicKeys"));
    }

    @Test
    public void getAllSourceAccount() {
        List<String> list = StandbyShufflingTest.allRecipientsPublicKeys();
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).feeRateNQTPerFXT(0L).param("recipientPublicKeys", list).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        Assert.assertTrue((boolean)jO.getBoolean("started"));
        jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.ASSET.getCode()).param("holding", "4348103880042995903").feeRateNQTPerFXT(0L).param("recipientPublicKeys", list).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        Assert.assertTrue((boolean)jO.getBoolean("started"));
        jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(BOB.getSecretPhrase()).param("holdingType", HoldingType.CURRENCY.getCode()).param("holding", "1").feeRateNQTPerFXT(0L).param("recipientPublicKeys", list).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        Assert.assertTrue((boolean)jO.getBoolean("started"));
        jO = new APICall.Builder("getStandbyShufflers").chain(ChildChain.IGNIS.getId()).unsignedLongParam("account", ALICE.getId()).secretPhrase(ALICE.getSecretPhrase()).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        JA jA = jO.getArray("standbyShufflers");
        Assert.assertNotNull((Object)jA);
        Assert.assertEquals((long)2L, (long)jA.size());
        Assert.assertEquals((Object)ALICE.getRsAccount(), (Object)jA.get(0).getString("accountRS"));
        Assert.assertEquals((Object)ALICE.getRsAccount(), (Object)jA.get(1).getString("accountRS"));
    }

    @Test
    public void getSameChainDifferentHoldingType() {
        List<String> list = StandbyShufflingTest.allRecipientsPublicKeys();
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).feeRateNQTPerFXT(0L).param("recipientPublicKeys", list).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        Assert.assertTrue((boolean)jO.getBoolean("started"));
        jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(BOB.getSecretPhrase()).param("holdingType", HoldingType.CURRENCY.getCode()).param("holding", "1").feeRateNQTPerFXT(0L).param("recipientPublicKeys", list).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        Assert.assertTrue((boolean)jO.getBoolean("started"));
        jO = new APICall.Builder("getStandbyShufflers").chain(ChildChain.IGNIS.getId()).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        JA jA = jO.getArray("standbyShufflers");
        Assert.assertNotNull((Object)jA);
        Assert.assertEquals((long)2L, (long)jA.size());
        JO jO2 = jA.get(0);
        JO jO3 = jA.get(1);
        Assert.assertEquals(Stream.of(ALICE.getRsAccount(), BOB.getRsAccount()).collect(Collectors.toSet()), Stream.of(jO2.get("accountRS"), jO3.get("accountRS")).collect(Collectors.toSet()));
    }

    @Test
    public void getDifferentChains() {
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).feeRateNQTPerFXT(0L).param("recipientPublicKeys", Collections.singletonList(RECIPIENT1.getPublicKeyStr())).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        Assert.assertTrue((boolean)jO.getBoolean("started"));
        jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.BITSWIFT.getId()).secretPhrase(BOB.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.BITSWIFT.getId()).feeRateNQTPerFXT(0L).param("recipientPublicKeys", Collections.singletonList(RECIPIENT2.getPublicKeyStr())).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        Assert.assertTrue((boolean)jO.getBoolean("started"));
        JA jA = this.getAllStandbyShufflers();
        Assert.assertEquals((long)2L, (long)jA.size());
        jO = new APICall.Builder("getStandbyShufflers").chain(ChildChain.BITSWIFT.getId()).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        jA = jO.getArray("standbyShufflers");
        Assert.assertNotNull((Object)jA);
        Assert.assertEquals((long)1L, (long)jA.size());
    }

    @Test
    public void testShuffling() {
        JO jO = new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).feeRateNQTPerFXT(ChildChain.IGNIS.ONE_COIN).param("recipientPublicKeys", Collections.singletonList(RECIPIENT1.getPublicKeyStr())).call();
        Assert.assertNull((Object)jO.get("errorCode"));
        Assert.assertTrue((boolean)jO.getBoolean("started"));
        JO jO2 = ShufflingUtil.create(BOB, 3);
        String string = jO2.getString("fullHash");
        StandbyShufflingTest.generateBlock();
        StandbyShufflingTest.generateBlock();
        JO jO3 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((long)ShufflingStage.REGISTRATION.getCode(), (long)jO3.getByte("stage"));
        JO jO4 = ShufflingUtil.getShufflingParticipants(string);
        JA jA = jO4.getArray("participants");
        Assert.assertEquals((long)2L, (long)jA.size());
        jO = GetShufflersCall.create().shufflingFullHash(string).call();
        JA jA2 = jO.getArray("shufflers");
        Assert.assertEquals((long)1L, (long)jA2.size());
        JO jO5 = jA2.get(0);
        Assert.assertEquals((Object)ALICE.getStrId(), (Object)jO5.getString("account"));
        Assert.assertEquals((Object)ALICE.getRsAccount(), (Object)jO5.getString("accountRS"));
        Assert.assertEquals((Object)RECIPIENT1.getStrId(), (Object)jO5.getString("recipient"));
        Assert.assertEquals((Object)RECIPIENT1.getRsAccount(), (Object)jO5.getString("recipientRS"));
    }

    @Test
    public void testNormalStandbyShufflerShutdown() {
        new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).feeRateNQTPerFXT(ChildChain.IGNIS.ONE_COIN).param("recipientPublicKeys", Collections.singletonList(RECIPIENT1.getPublicKeyStr())).call();
        new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(BOB.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).feeRateNQTPerFXT(ChildChain.IGNIS.ONE_COIN).param("recipientPublicKeys", Arrays.asList(RECIPIENT2.getPublicKeyStr(), RECIPIENT3.getPublicKeyStr())).call();
        JO jO = ShufflingUtil.create(CHUCK, 3);
        String string = jO.getString("fullHash");
        ShufflingUtil.startShuffler(CHUCK, RECIPIENT4, string);
        StandbyShufflingTest.generateBlockAndSleep();
        Assert.assertEquals((long)2L, (long)this.getAllStandbyShufflers().size());
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((long)ShufflingStage.REGISTRATION.getCode(), (long)jO2.getByte("stage"));
        JA jA = ShufflingUtil.getShufflingParticipants(string).getArray("participants");
        Assert.assertEquals((long)1L, (long)jA.size());
        StandbyShufflingTest.generateBlockAndSleep();
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((long)ShufflingStage.PROCESSING.getCode(), (long)jO2.getByte("stage"));
        jA = ShufflingUtil.getShufflingParticipants(string).getArray("participants");
        Assert.assertEquals((long)3L, (long)jA.size());
        for (JO jO3 : jA.objects()) {
            Assert.assertEquals((long)ShufflingParticipantHome.State.REGISTERED.getCode(), (long)jO3.getByte("state"));
        }
        for (int i = 0; i < 3; ++i) {
            StandbyShufflingTest.generateBlockAndSleep();
        }
        Assert.assertEquals((long)1L, (long)this.getAllStandbyShufflers().size());
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((long)ShufflingStage.VERIFICATION.getCode(), (long)jO2.getByte("stage"));
    }

    @Test
    public void testRecoverPublicKey() {
        new APICall.Builder("startStandbyShuffler").chain(ChildChain.IGNIS.getId()).secretPhrase(ALICE.getSecretPhrase()).param("holdingType", HoldingType.COIN.getCode()).param("holding", ChildChain.IGNIS.getId()).feeRateNQTPerFXT(ChildChain.IGNIS.ONE_COIN).param("recipientPublicKeys", Collections.singletonList(RECIPIENT1.getPublicKeyStr())).call();
        JA jA = this.getAllStandbyShufflers();
        Assert.assertEquals((long)1L, (long)jA.size());
        Assert.assertEquals((long)1L, (long)jA.get(0).getArray("recipientPublicKeys").size());
        JO jO = ShufflingUtil.create(CHUCK, 3);
        String string = jO.getString("fullHash");
        StandbyShufflingTest.generateBlocks(9);
        jA = this.getAllStandbyShufflers();
        Assert.assertEquals((long)1L, (long)jA.size());
        Assert.assertEquals((long)0L, (long)jA.get(0).getArray("recipientPublicKeys").size());
        JO jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((long)ShufflingStage.REGISTRATION.getCode(), (long)jO2.getByte("stage"));
        StandbyShufflingTest.generateBlockAndSleep();
        jA = this.getAllStandbyShufflers();
        Assert.assertEquals((long)1L, (long)jA.size());
        Assert.assertEquals((long)0L, (long)jA.get(0).getArray("recipientPublicKeys").size());
        jO2 = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((long)ShufflingStage.CANCELLED.getCode(), (long)jO2.getByte("stage"));
        StandbyShufflingTest.generateBlock();
        jA = this.getAllStandbyShufflers();
        Assert.assertEquals((long)1L, (long)jA.size());
        Assert.assertEquals((long)1L, (long)jA.get(0).getArray("recipientPublicKeys").size());
    }

    private JA getAllStandbyShufflers() {
        JO jO = new APICall.Builder("getStandbyShufflers").chain("").call();
        Assert.assertNull((Object)jO.get("errorCode"));
        JA jA = jO.getArray("standbyShufflers");
        Assert.assertNotNull((Object)jA);
        return jA;
    }
}

