/*
 * Decompiled with CFR 0.152.
 */
package nxt.ae;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nxt.BlockchainTest;
import nxt.Tester;
import nxt.ae.Asset;
import nxt.ae.AssetFreezeMonitor;
import nxt.blockchain.ChildChain;
import nxt.db.TransactionalDb;
import nxt.http.APICall;
import nxt.http.assetexchange.AssetExchangeTest;
import nxt.http.client.GetAccountCurrentOrderIdsBuilder;
import nxt.http.client.PlaceAssetOrderBuilder;
import nxt.http.client.SetAssetPropertyBuilder;
import org.junit.Assert;
import org.junit.Test;

public class AssetFreezeMonitorTest
extends BlockchainTest {
    @Test
    public void testOnBlockFreezeAsset() {
        Asset asset = this.createAssetWithOrders();
        AssetFreezeMonitorTest.setAssetFreezeHeight(asset, this.getHeight() + 1);
        AssetFreezeMonitorTest.generateBlock();
        this.assertFrozen(asset);
    }

    @Test
    public void testOnBlockFreezeAssetOnPropertySet() {
        Asset asset = this.createAssetWithOrders();
        AssetFreezeMonitorTest.setAssetFreezeHeight(asset, 0);
        this.setAssetFreezeProperty(asset, this.getHeight() + 2);
        AssetFreezeMonitorTest.generateBlock();
        AssetFreezeMonitorTest.generateBlock();
        this.assertFrozen(asset);
    }

    private void setAssetFreezeProperty(Asset asset, int n) {
        new SetAssetPropertyBuilder(ALICE, asset.getId(), "Freeze", String.valueOf(n)).invokeNoError();
    }

    @Test
    public void testOnBlockTooEarlyToFreezeAsset() {
        Asset asset = this.createAssetWithOrders();
        AssetFreezeMonitorTest.setAssetFreezeHeight(asset, this.getHeight() + 2);
        AssetFreezeMonitorTest.generateBlock();
        this.assertLiquid(asset);
    }

    @Test
    public void testOnBlockNoReasonToFreezeAsset() {
        Asset asset = this.createAssetWithOrders();
        AssetFreezeMonitorTest.generateBlock();
        this.assertLiquid(asset);
    }

    @Test
    public void testOnBlockTooLateToFreezeAsset() {
        Asset asset = this.createAssetWithOrders();
        AssetFreezeMonitorTest.setAssetFreezeHeight(asset, this.getHeight());
        AssetFreezeMonitorTest.generateBlock();
        this.assertHasOrders(asset);
    }

    @Test
    public void testFrozenAssetBidOrderRejected() {
        Asset asset = this.createFrozenAsset();
        this.assetTransactionsImpossible(asset);
    }

    private void assetTransactionsImpossible(Asset asset) {
        long l = asset.getId();
        APICall.InvocationError invocationError = new PlaceAssetOrderBuilder(ALICE, l, 10L, ChildChain.IGNIS.ONE_COIN * 2L).setFeeNQT(ChildChain.IGNIS.ONE_COIN).placeAskOrderWithError();
        Assert.assertEquals((Object)("Asset " + Long.toUnsignedString(l) + " is frozen, no transaction is possible."), (Object)invocationError.getErrorDescription());
    }

    private void assetTransactionsPossible(Asset asset) {
        long l = asset.getId();
        new PlaceAssetOrderBuilder(ALICE, l, 10L, ChildChain.IGNIS.ONE_COIN * 2L).setFeeNQT(ChildChain.IGNIS.ONE_COIN).placeAskOrder();
    }

    private Asset createFrozenAsset() {
        Asset asset = Asset.getAsset((long)AssetExchangeTest.issueAsset(ALICE, "AssetC").getAssetId());
        AssetFreezeMonitorTest.setAssetFreezeHeight(asset, this.getHeight() - 1);
        return asset;
    }

    private Asset createAssetWithOrders() {
        long l = AssetExchangeTest.issueAsset(ALICE, "AssetC").getAssetId();
        new PlaceAssetOrderBuilder(ALICE, l, 10L, ChildChain.IGNIS.ONE_COIN * 2L).setFeeNQT(ChildChain.IGNIS.ONE_COIN).placeAskOrder();
        new PlaceAssetOrderBuilder(CHUCK, l, 5L, ChildChain.IGNIS.ONE_COIN).setFeeNQT(ChildChain.IGNIS.ONE_COIN).placeBidOrder();
        AssetFreezeMonitorTest.generateBlock();
        return Asset.getAsset((long)l);
    }

    public static void setAssetFreezeHeight(Asset asset, int n) {
        TransactionalDb.runInDbTransaction(() -> AssetFreezeMonitor.enableFreeze((long)asset.getId(), (int)1, (int)n));
    }

    private void assertLiquid(Asset asset) {
        this.assertHasOrders(asset);
        this.assetTransactionsPossible(asset);
    }

    private void assertHasOrders(Asset asset) {
        List<String> list = this.getOrders(asset);
        Assert.assertEquals((String)("Actual order ids: " + list), (long)2L, (long)list.size());
    }

    private void assertFrozen(Asset asset) {
        this.assertHasNoOrders(asset);
        this.assetTransactionsImpossible(asset);
    }

    private void assertHasNoOrders(Asset asset) {
        Assert.assertEquals(Collections.emptyList(), this.getOrders(asset));
    }

    private List<String> getOrders(Asset asset) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Tester tester : Arrays.asList(ALICE, CHUCK)) {
            GetAccountCurrentOrderIdsBuilder getAccountCurrentOrderIdsBuilder = new GetAccountCurrentOrderIdsBuilder(tester.getId()).setAssetId(asset.getId());
            arrayList.addAll(getAccountCurrentOrderIdsBuilder.getAskOrders());
            arrayList.addAll(getAccountCurrentOrderIdsBuilder.getBidOrders());
        }
        return arrayList;
    }
}

