/*
 * Decompiled with CFR 0.152.
 */
package nxt.ae;

import java.io.File;
import java.net.URISyntaxException;
import java.util.HashMap;
import nxt.BlockchainTest;
import nxt.DeleteFileRule;
import nxt.Tester;
import nxt.ae.Asset;
import nxt.ae.AssetFreezeMonitorTest;
import nxt.ae.AssetMigrateMonitor;
import nxt.ae.AssetSnapshot;
import nxt.blockchain.ChildChain;
import nxt.db.TransactionalDb;
import nxt.http.assetexchange.AssetExchangeTest;
import nxt.http.client.SetAssetPropertyBuilder;
import nxt.http.client.TransferAssetBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class AssetMigrateMonitorTest
extends BlockchainTest {
    @Rule
    public final DeleteFileRule deleteFileRule = new DeleteFileRule();
    private final ChildChain targetChain = ChildChain.AEUR;
    private final long chuckAssetQnt = 3L;
    private final long bobAssetQnt = 2L;
    private Tester assetOwner;

    @Before
    public void setUp() {
        this.assetOwner = ALICE;
    }

    @Test
    public void migratesAssetToChildChainWithoutSnapshot() {
        Asset asset = this.createAssetWithBalances();
        AssetMigrateMonitorTest.generateBlock();
        this.freezeAsset(asset, this.getHeight());
        this.setAssetMigrationHeight(asset, this.getHeight() + 1);
        AssetMigrateMonitorTest.generateBlock();
        this.assertTokensDistributed();
    }

    @Test
    public void setMigrationHeightUsingAssetProperty() {
        Asset asset = this.createAssetWithBalances();
        AssetMigrateMonitorTest.generateBlock();
        this.freezeAsset(asset, this.getHeight());
        this.setAssetMinMigrationHeight(asset, this.getHeight());
        this.setAssetMigrationAssetProperty(asset, this.getHeight() + 2);
        AssetMigrateMonitorTest.generateBlock();
        AssetMigrateMonitorTest.generateBlock();
        this.assertTokensDistributed();
    }

    private void setAssetMigrationAssetProperty(Asset asset, int n) {
        String string = "Migrate" + Long.toUnsignedString(asset.getId());
        String string2 = Integer.toString(n);
        new SetAssetPropertyBuilder(this.assetOwner, asset.getId(), string, string2).invokeNoError();
    }

    @Test
    public void migratesAssetToChildChainUsingSnapshot() throws URISyntaxException {
        Asset asset = this.createAsset();
        AssetMigrateMonitorTest.generateBlock();
        int n = this.getHeight();
        this.freezeAsset(asset, n);
        this.createFakeSnapshot(asset, n);
        this.setAssetMigrationHeight(asset, this.getHeight() + 1);
        AssetMigrateMonitorTest.generateBlock();
        this.assertTokensDistributed();
    }

    private void createFakeSnapshot(Asset asset, int n) throws URISyntaxException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put(Long.toUnsignedString(BOB.getId()), 2L);
        hashMap.put(Long.toUnsignedString(CHUCK.getId()), 3L);
        File file = new AssetSnapshot().writeSnapshot(hashMap, asset.getId(), n);
        this.deleteFileRule.addFile(file);
        this.deleteFileRule.moveToTestClasspath(file);
    }

    private void assertTokensDistributed() {
        Assert.assertEquals((long)2L, (long)BOB.getChainBalanceDiff(this.targetChain.getId()));
        Assert.assertEquals((long)3L, (long)CHUCK.getChainBalanceDiff(this.targetChain.getId()));
    }

    private void setAssetMigrationHeight(Asset asset, int n) {
        TransactionalDb.runInDbTransaction(() -> AssetMigrateMonitor.enableMigration((long)asset.getId(), (ChildChain)this.targetChain, (int)0, (int)n));
    }

    private void setAssetMinMigrationHeight(Asset asset, int n) {
        TransactionalDb.runInDbTransaction(() -> AssetMigrateMonitor.enableMigration((long)asset.getId(), (ChildChain)this.targetChain, (int)n, (int)0));
    }

    private Asset createAssetWithBalances() {
        Asset asset = this.createAsset();
        this.transfer(asset.getId(), BOB, 2L);
        this.transfer(asset.getId(), CHUCK, 3L);
        return asset;
    }

    private Asset createAsset() {
        return Asset.getAsset((long)AssetExchangeTest.issueAsset(this.assetOwner, "AssetC").getAssetId());
    }

    private void transfer(long l, Tester tester, long l2) {
        new TransferAssetBuilder(l, this.assetOwner, tester).setQuantityQNT(l2).transfer();
    }

    private void freezeAsset(Asset asset, int n) {
        AssetFreezeMonitorTest.setAssetFreezeHeight(asset, n);
    }
}

