/*
 * Decompiled with CFR 0.152.
 */
package nxt.crypto;

import java.security.SecureRandom;
import nxt.crypto.Curve25519;
import nxt.util.Convert;
import org.bouncycastle.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class Curve25519Test {
    private static final String ALICE_SECRET = "77076d0a7318a57d3c16c17251b26645df4c2f87ebc0992ab177fba51db92c2a";
    private static final String ALICE_PUBLIC = "8520f0098930a754748b7ddcb43ef75a0dbf3a0d26381af4eba4a98eaa9b4e6a";
    private static final String BOB_SECRET = "5dab087e624a8a4b79e17f8b83800ee66f3bb1292618b6fd1c2f8b27ff88e0eb";
    private static final String BOB_PUBLIC = "de9edb7d7b7dc1b4d35b61c2ece435373f8343c85b78674dadfc7e146f882b4f";

    @Test
    public void testAliceVector() {
        this.checkVector(ALICE_SECRET, ALICE_PUBLIC);
    }

    @Test
    public void testBobVector() {
        this.checkVector(BOB_SECRET, BOB_PUBLIC);
    }

    @Test
    public void testCheckVerify() {
        byte[] byArray = new byte[32];
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = Convert.parseHexString((String)ALICE_SECRET);
        Curve25519.keygen((byte[])byArray4, (byte[])byArray3, (byte[])byArray5);
        new SecureRandom().nextBytes(byArray2);
        Curve25519.sign((byte[])byArray, (byte[])byArray2, (byte[])byArray5, (byte[])byArray3);
        byte[] byArray6 = new byte[32];
        Curve25519.verify((byte[])byArray6, (byte[])byArray, (byte[])byArray2, (byte[])byArray4);
        Assert.assertArrayEquals((byte[])byArray6, (byte[])byArray4);
    }

    @Test
    public void testAlterSignature() {
        byte[] byArray = new byte[32];
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = new byte[32];
        byte[] byArray5 = Convert.parseHexString((String)ALICE_SECRET);
        Curve25519.keygen((byte[])byArray4, (byte[])byArray3, (byte[])byArray5);
        new SecureRandom().nextBytes(byArray2);
        Curve25519.sign((byte[])byArray, (byte[])byArray2, (byte[])byArray5, (byte[])byArray3);
        byArray[0] = (byte)(byArray[0] + 1);
        byte[] byArray6 = new byte[32];
        Curve25519.verify((byte[])byArray6, (byte[])byArray, (byte[])byArray2, (byte[])byArray4);
        if (Arrays.areEqual((byte[])byArray6, (byte[])byArray4)) {
            Assert.fail((String)"Should not verify, as signature is altered");
        }
    }

    private void checkVector(String string, String string2) {
        byte[] byArray = Convert.parseHexString((String)string);
        byte[] byArray2 = Convert.parseHexString((String)string2);
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = new byte[32];
        Curve25519.keygen((byte[])byArray3, (byte[])byArray4, (byte[])byArray);
        Assert.assertArrayEquals((byte[])byArray2, (byte[])byArray3);
    }
}

