/*
 * Decompiled with CFR 0.152.
 */
package nxt.crypto;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import nxt.BlockchainTest;
import nxt.crypto.Crypto;
import nxt.crypto.SecretShare;
import nxt.crypto.SecretSharingGenerator;
import nxt.crypto.SimpleShamirSecretSharing;
import org.junit.Assert;
import org.junit.Test;

public class SimpleShamirSecretSharingTest
extends BlockchainTest {
    private static final BigInteger ALICE_SECRET_PHRASE_128_BIT = new BigInteger("298106192037605529109565170145082624171");

    @Test
    public void wikipediaExample() {
        BigInteger bigInteger = new BigInteger("1613");
        BigInteger bigInteger2 = new BigInteger("1234");
        SecretShare[] secretShareArray = new SimpleShamirSecretSharing().split(bigInteger2, 3, 5, bigInteger, (Random)Crypto.getSecureRandom());
        SecretShare[] secretShareArray2 = new SecretShare[]{secretShareArray[0], secretShareArray[2], secretShareArray[3]};
        BigInteger bigInteger3 = new SimpleShamirSecretSharing().combine(secretShareArray2, bigInteger);
        Assert.assertEquals((Object)bigInteger3, (Object)bigInteger2);
        SecretShare[] secretShareArray3 = new SecretShare[]{secretShareArray[0], secretShareArray[1], secretShareArray[4]};
        bigInteger3 = new SimpleShamirSecretSharing().combine(secretShareArray3, bigInteger);
        Assert.assertEquals((Object)bigInteger3, (Object)bigInteger2);
        SecretShare[] secretShareArray4 = new SecretShare[]{secretShareArray[0], secretShareArray[4]};
        bigInteger3 = new SimpleShamirSecretSharing().combine(secretShareArray4, bigInteger);
        Assert.assertNotEquals((Object)bigInteger3, (Object)bigInteger2);
    }

    @Test
    public void splitAndCombine() {
        SimpleShamirSecretSharing simpleShamirSecretSharing = new SimpleShamirSecretSharing();
        SecretShare[] secretShareArray = simpleShamirSecretSharing.split(ALICE_SECRET_PHRASE_128_BIT, 3, 5, SecretSharingGenerator.PRIME_4096_BIT, (Random)new SecureRandom());
        Arrays.stream(secretShareArray).forEach(secretShare -> Assert.assertTrue((secretShare.getShare().compareTo(BigInteger.ZERO) > 0 && secretShare.getShare().compareTo(SecretSharingGenerator.PRIME_4096_BIT) < 0 ? 1 : 0) != 0));
        BigInteger bigInteger = simpleShamirSecretSharing.combine(secretShareArray, SecretSharingGenerator.PRIME_4096_BIT);
        Assert.assertEquals((Object)ALICE_SECRET_PHRASE_128_BIT, (Object)bigInteger);
        secretShareArray = simpleShamirSecretSharing.split(ALICE_SECRET_PHRASE_128_BIT, 2, 3, SecretSharingGenerator.PRIME_384_BIT, (Random)new SecureRandom());
        Arrays.stream(secretShareArray).forEach(secretShare -> Assert.assertTrue((secretShare.getShare().compareTo(BigInteger.ZERO) > 0 && secretShare.getShare().compareTo(SecretSharingGenerator.PRIME_384_BIT) < 0 ? 1 : 0) != 0));
        bigInteger = simpleShamirSecretSharing.combine(secretShareArray, SecretSharingGenerator.PRIME_384_BIT);
        Assert.assertEquals((Object)ALICE_SECRET_PHRASE_128_BIT, (Object)bigInteger);
        secretShareArray = simpleShamirSecretSharing.split(ALICE_SECRET_PHRASE_128_BIT, 2, 3, SecretSharingGenerator.PRIME_192_BIT, (Random)new SecureRandom());
        Arrays.stream(secretShareArray).forEach(secretShare -> Assert.assertTrue((secretShare.getShare().compareTo(BigInteger.ZERO) > 0 && secretShare.getShare().compareTo(SecretSharingGenerator.PRIME_192_BIT) < 0 ? 1 : 0) != 0));
        bigInteger = simpleShamirSecretSharing.combine(secretShareArray, SecretSharingGenerator.PRIME_192_BIT);
        Assert.assertEquals((Object)ALICE_SECRET_PHRASE_128_BIT, (Object)bigInteger);
    }

    @Test
    public void splitAndCombineRandomSecretPhrase() {
        SimpleShamirSecretSharing simpleShamirSecretSharing = new SimpleShamirSecretSharing();
        SecretShare[] secretShareArray = simpleShamirSecretSharing.split(new BigInteger("eOdBVLMgySFvyiTy8xMuRXDTr45oTzB7L5J".getBytes(StandardCharsets.UTF_8)), 4, 7, SecretSharingGenerator.PRIME_4096_BIT, (Random)new SecureRandom());
        SecretShare[] secretShareArray2 = new SecretShare[]{secretShareArray[1], secretShareArray[3], secretShareArray[5], secretShareArray[6]};
        BigInteger bigInteger = simpleShamirSecretSharing.combine(secretShareArray2, SecretSharingGenerator.PRIME_4096_BIT);
        Assert.assertEquals((Object)"eOdBVLMgySFvyiTy8xMuRXDTr45oTzB7L5J", (Object)new String(bigInteger.toByteArray(), StandardCharsets.UTF_8));
        secretShareArray2 = new SecretShare[]{secretShareArray[0], secretShareArray[2], secretShareArray[3], secretShareArray[6], secretShareArray[4]};
        bigInteger = simpleShamirSecretSharing.combine(secretShareArray2, SecretSharingGenerator.PRIME_4096_BIT);
        Assert.assertEquals((Object)"eOdBVLMgySFvyiTy8xMuRXDTr45oTzB7L5J", (Object)new String(bigInteger.toByteArray(), StandardCharsets.UTF_8));
        secretShareArray2 = new SecretShare[]{secretShareArray[2], secretShareArray[3], secretShareArray[6]};
        bigInteger = simpleShamirSecretSharing.combine(secretShareArray2, SecretSharingGenerator.PRIME_4096_BIT);
        Assert.assertNotEquals((Object)"eOdBVLMgySFvyiTy8xMuRXDTr45oTzB7L5J", (Object)new String(bigInteger.toByteArray(), StandardCharsets.UTF_8));
    }
}

